/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.file;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.connector.file.config.FileConfig;
import org.dbsyncer.connector.file.model.FileSchema;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.model.Field;
import org.springframework.util.Assert;

public final class FileConnectorInstance
implements ConnectorInstance<FileConfig, String> {
    private FileConfig config;
    private List<FileSchema> fileSchemaList;
    private Map<String, FileResolver> fileSchemaMap = new ConcurrentHashMap<String, FileResolver>();

    public FileConnectorInstance(FileConfig config) {
        this.config = config;
        this.fileSchemaList = JsonUtil.jsonToArray((String)config.getSchema(), FileSchema.class);
        Assert.notEmpty(this.fileSchemaList, (String)"The schema is empty.");
        for (FileSchema fileSchema : this.fileSchemaList) {
            List<Field> fields = fileSchema.getFields();
            Assert.notEmpty(fields, (String)"The fields of file schema is empty.");
            if (this.fileSchemaMap.containsKey(fileSchema.getFileName())) continue;
            this.fileSchemaMap.put(fileSchema.getFileName(), new FileResolver(fileSchema));
        }
    }

    public String getServiceUrl() {
        return this.config.getFileDir();
    }

    public FileConfig getConfig() {
        return this.config;
    }

    public void setConfig(FileConfig config) {
        this.config = config;
    }

    public String getConnection() {
        return this.config.getFileDir();
    }

    public void close() {
        this.fileSchemaMap.clear();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public List<FileSchema> getFileSchemaList() {
        return this.fileSchemaList;
    }

    public FileSchema getFileSchema(String tableName) {
        FileResolver fileResolver = this.fileSchemaMap.get(tableName);
        Assert.notNull((Object)fileResolver, (String)String.format("can not find fileSchema by tableName '%s'", tableName));
        return fileResolver.fileSchema;
    }

    public String getFilePath(String tableName) {
        FileResolver fileResolver = this.fileSchemaMap.get(tableName);
        Assert.notNull((Object)fileResolver, (String)String.format("can not find fileSchema by tableName '%s'", tableName));
        return fileResolver.filePath;
    }

    class FileResolver {
        FileSchema fileSchema;
        String filePath;

        public FileResolver(FileSchema fileSchema) {
            this.fileSchema = fileSchema;
            this.filePath = FileConnectorInstance.this.config.getFileDir().concat(fileSchema.getFileName());
            File file = new File(this.filePath);
            Assert.isTrue((boolean)file.exists(), (String)String.format("found not file '%s'", this.filePath));
        }
    }
}

