/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.manager;

import java.time.Instant;
import java.util.Map;
import javax.annotation.Resource;
import org.dbsyncer.manager.Puller;
import org.dbsyncer.manager.event.ClosedEvent;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.enums.MetaEnum;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ManagerFactory
implements ApplicationListener<ClosedEvent> {
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private Map<String, Puller> map;

    public void onApplicationEvent(ClosedEvent event) {
        this.changeMetaState(event.getMetaId(), MetaEnum.READY);
    }

    public void start(Mapping mapping) {
        Puller puller = this.getPuller(mapping);
        this.changeMetaState(mapping.getMetaId(), MetaEnum.RUNNING);
        puller.start(mapping);
    }

    public void close(Mapping mapping) {
        Puller puller = this.getPuller(mapping);
        String metaId = mapping.getMetaId();
        this.changeMetaState(metaId, MetaEnum.STOPPING);
        puller.close(metaId);
    }

    public void changeMetaState(String metaId, MetaEnum metaEnum) {
        Meta meta = this.profileComponent.getMeta(metaId);
        int code = metaEnum.getCode();
        if (null != meta && meta.getState() != code) {
            meta.setState(code);
            meta.setUpdateTime(Long.valueOf(Instant.now().toEpochMilli()));
            this.profileComponent.editConfigModel((ConfigModel)meta);
        }
    }

    private Puller getPuller(Mapping mapping) {
        Assert.notNull((Object)mapping, (String)"\u9a71\u52a8\u4e0d\u80fd\u4e3a\u7a7a");
        String model = mapping.getModel();
        String metaId = mapping.getMetaId();
        Assert.hasText((String)model, (String)"\u540c\u6b65\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)metaId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        Puller puller = this.map.get(model.concat("Puller"));
        Assert.notNull((Object)puller, (String)String.format("\u672a\u77e5\u7684\u540c\u6b65\u65b9\u5f0f: %s", model));
        return puller;
    }
}

