/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.checker;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dbsyncer.biz.checker.Checker;
import org.dbsyncer.biz.enums.SafeInfoEnum;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.model.AbstractConfigModel;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Convert;
import org.dbsyncer.plugin.PluginFactory;
import org.dbsyncer.plugin.model.Plugin;
import org.dbsyncer.sdk.model.Filter;
import org.dbsyncer.storage.impl.SnowflakeIdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractChecker
implements Checker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String SYMBOL = "***";
    @Resource
    private PluginFactory pluginFactory;
    @Resource
    private SnowflakeIdWorker snowflakeIdWorker;

    protected void modifyConfigModel(ConfigModel model, Map<String, String> params) {
        Assert.notNull((Object)model, (String)"ConfigModel can not be null.");
        Assert.hasText((String)model.getType(), (String)"ConfigModel type can not be empty.");
        Assert.hasText((String)model.getName(), (String)"ConfigModel name can not be empty.");
        String name = params.get("name");
        if (StringUtil.isNotBlank((CharSequence)name)) {
            model.setName(name);
        }
        model.setId(StringUtil.isBlank((CharSequence)model.getId()) ? String.valueOf(this.snowflakeIdWorker.nextId()) : model.getId());
        long now = Instant.now().toEpochMilli();
        model.setCreateTime(Long.valueOf(null == model.getCreateTime() ? now : model.getCreateTime()));
        model.setUpdateTime(Long.valueOf(now));
    }

    protected void modifySuperConfigModel(AbstractConfigModel model, Map<String, String> params) {
        List plugins;
        String convertJson;
        String mappingParams = params.get("params");
        model.setParams(StringUtil.isNotBlank((CharSequence)mappingParams) ? (Map)JsonUtil.jsonToObj((String)mappingParams, Map.class) : new LinkedHashMap());
        String filterJson = params.get("filter");
        if (StringUtil.isNotBlank((CharSequence)filterJson)) {
            List list = JsonUtil.jsonToArray((String)filterJson, Filter.class);
            model.setFilter(list);
        }
        if (StringUtil.isNotBlank((CharSequence)(convertJson = params.get("convert")))) {
            List convert = JsonUtil.jsonToArray((String)convertJson, Convert.class);
            model.setConvert(convert);
        }
        String pluginId = params.get("pluginId");
        Plugin plugin = null;
        if (StringUtil.isNotBlank((CharSequence)pluginId) && !CollectionUtils.isEmpty((Collection)(plugins = this.pluginFactory.getPluginAll()))) {
            for (Plugin p : plugins) {
                if (!StringUtil.equals((CharSequence)this.pluginFactory.createPluginId(p.getClassName(), p.getVersion()), (CharSequence)pluginId)) continue;
                plugin = p;
                break;
            }
        }
        model.setPlugin(plugin);
    }

    protected void printParams(Map<String, String> params) {
        HashMap<String, String> checkParams = new HashMap<String, String>(params);
        for (SafeInfoEnum s : SafeInfoEnum.values()) {
            if (!params.containsKey(s.getCode())) continue;
            checkParams.put(s.getCode(), SYMBOL);
        }
        this.logger.info("params:{}", checkParams);
    }
}

