/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.checker.impl.mapping;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dbsyncer.biz.checker.AbstractChecker;
import org.dbsyncer.biz.checker.MappingConfigChecker;
import org.dbsyncer.biz.checker.impl.tablegroup.TableGroupChecker;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.AbstractConfigModel;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.config.ListenerConfig;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.enums.ModelEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class MappingChecker
extends AbstractChecker {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private TableGroupChecker tableGroupChecker;
    @Resource
    private Map<String, MappingConfigChecker> map;

    @Override
    public ConfigModel checkAddConfigModel(Map<String, String> params) {
        this.logger.info("params:{}", params);
        String name = params.get("name");
        String sourceConnectorId = params.get("sourceConnectorId");
        String targetConnectorId = params.get("targetConnectorId");
        Assert.hasText((String)name, (String)"\u9a71\u52a8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)sourceConnectorId, (String)"\u6570\u636e\u6e90\u4e0d\u80fd\u4e3a\u7a7a.");
        Assert.hasText((String)targetConnectorId, (String)"\u76ee\u6807\u6e90\u4e0d\u80fd\u4e3a\u7a7a.");
        Mapping mapping = new Mapping();
        mapping.setName(name);
        mapping.setSourceConnectorId(sourceConnectorId);
        mapping.setTargetConnectorId(targetConnectorId);
        mapping.setModel(ModelEnum.FULL.getCode());
        mapping.setListener(new ListenerConfig(ListenerTypeEnum.LOG.getType()));
        mapping.setParams(new HashMap());
        this.modifyConfigModel((ConfigModel)mapping, params);
        this.addMeta(mapping);
        return mapping;
    }

    @Override
    public ConfigModel checkEditConfigModel(Map<String, String> params) {
        this.logger.info("params:{}", params);
        Assert.notEmpty(params, (String)"MappingChecker check params is null.");
        String id = params.get("id");
        Mapping mapping = this.profileComponent.getMapping(id);
        Assert.notNull((Object)mapping, (String)"Can not find mapping.");
        this.modifyConfigModel((ConfigModel)mapping, params);
        String model = params.get("model");
        mapping.setModel(null != ModelEnum.getModelEnum((String)model) ? model : ModelEnum.FULL.getCode());
        mapping.setReadNum(NumberUtil.toInt((String)params.get("readNum"), (int)mapping.getReadNum()));
        mapping.setBatchNum(NumberUtil.toInt((String)params.get("batchNum"), (int)mapping.getBatchNum()));
        mapping.setThreadNum(NumberUtil.toInt((String)params.get("threadNum"), (int)mapping.getThreadNum()));
        String incrementStrategy = params.get("incrementStrategy");
        Assert.hasText((String)incrementStrategy, (String)"MappingChecker check params incrementStrategy is empty");
        String type = StringUtil.toLowerCaseFirstOne((String)incrementStrategy).concat("ConfigChecker");
        MappingConfigChecker checker = this.map.get(type);
        Assert.notNull((Object)checker, (String)"Checker can not be null.");
        checker.modify(mapping, params);
        this.updateListenerConfig(mapping.getListener(), params);
        this.modifySuperConfigModel((AbstractConfigModel)mapping, params);
        String metaSnapshot = params.get("metaSnapshot");
        this.updateMeta(mapping, metaSnapshot);
        return mapping;
    }

    public void addMeta(Mapping mapping) {
        Meta meta = new Meta();
        meta.setMappingId(mapping.getId());
        this.modifyConfigModel((ConfigModel)meta, new HashMap<String, String>());
        String id = this.profileComponent.addConfigModel((ConfigModel)meta);
        mapping.setMetaId(id);
    }

    public void updateMeta(Mapping mapping) {
        this.updateMeta(mapping, null);
    }

    public void batchMergeTableGroupConfig(Mapping mapping, Map<String, String> params) {
        List groupAll = this.profileComponent.getTableGroupAll(mapping.getId());
        if (!CollectionUtils.isEmpty((Collection)groupAll)) {
            String[] sortedTableGroupIds = StringUtil.split((String)params.get("sortedTableGroupIds"), (String)"|");
            if (null != sortedTableGroupIds && sortedTableGroupIds.length > 0) {
                int size;
                Map<String, TableGroup> tableGroupMap = groupAll.stream().collect(Collectors.toMap(ConfigModel::getId, f -> f, (k1, k2) -> k1));
                groupAll.clear();
                for (int i = size = sortedTableGroupIds.length; i > 0; --i) {
                    TableGroup g = tableGroupMap.get(sortedTableGroupIds[size - i]);
                    Assert.notNull((Object)g, (String)"Invalid sorted tableGroup.");
                    g.setIndex(i);
                    groupAll.add(g);
                }
            }
            for (TableGroup g : groupAll) {
                this.tableGroupChecker.mergeConfig(mapping, g);
                this.profileComponent.editConfigModel((ConfigModel)g);
            }
        }
    }

    private void updateListenerConfig(ListenerConfig listener, Map<String, String> params) {
        Assert.notNull((Object)listener, (String)"ListenerConfig can not be null.");
        listener.setBanUpdate(StringUtil.isNotBlank((CharSequence)params.get("banUpdate")));
        listener.setBanInsert(StringUtil.isNotBlank((CharSequence)params.get("banInsert")));
        listener.setBanDelete(StringUtil.isNotBlank((CharSequence)params.get("banDelete")));
        listener.setBanDDL(StringUtil.isNotBlank((CharSequence)params.get("banDDL")));
    }

    private void updateMeta(Mapping mapping, String metaSnapshot) {
        Map snapshot;
        Meta meta = this.profileComponent.getMeta(mapping.getMetaId());
        Assert.notNull((Object)meta, (String)"\u9a71\u52a8meta\u4e0d\u5b58\u5728.");
        meta.clear();
        if (StringUtil.isNotBlank((CharSequence)metaSnapshot) && !CollectionUtils.isEmpty((Map)(snapshot = (Map)JsonUtil.jsonToObj((String)metaSnapshot, HashMap.class)))) {
            meta.setSnapshot(snapshot);
        }
        this.getMetaTotal(meta, mapping.getModel());
        meta.setUpdateTime(Long.valueOf(Instant.now().toEpochMilli()));
        this.profileComponent.editConfigModel((ConfigModel)meta);
    }

    private void getMetaTotal(Meta meta, String model) {
        if (ModelEnum.isFull((String)model)) {
            AtomicLong count = new AtomicLong(0L);
            List groupAll = this.profileComponent.getTableGroupAll(meta.getMappingId());
            if (!CollectionUtils.isEmpty((Collection)groupAll)) {
                for (TableGroup g : groupAll) {
                    count.getAndAdd(g.getSourceTable().getCount());
                }
            }
            meta.setTotal(count);
        }
    }
}

