/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import javax.annotation.Resource;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.MessageService;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.enums.MetaEnum;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.enums.ModelEnum;
import org.springframework.util.Assert;

public class BaseServiceImpl {
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private LogService logService;
    @Resource
    private MessageService messageService;
    protected static final Object LOCK = new Object();

    protected boolean isRunning(String metaId) {
        Meta meta = this.profileComponent.getMeta(metaId);
        if (null != meta) {
            int state = meta.getState();
            return MetaEnum.isRunning((int)state);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertRunning(String metaId) {
        Object object = LOCK;
        synchronized (object) {
            Assert.isTrue((!this.isRunning(metaId) ? 1 : 0) != 0, (String)"\u9a71\u52a8\u6b63\u5728\u8fd0\u884c, \u8bf7\u5148\u505c\u6b62.");
        }
    }

    protected void assertRunning(Mapping mapping) {
        Assert.notNull((Object)mapping, (String)"mapping can not be null.");
        this.assertRunning(mapping.getMetaId());
    }

    protected void log(LogType log, ConfigModel model) {
        if (null != model) {
            this.logService.log(log, "%s%s:%s", new Object[]{log.getMessage(), log.getName(), model.getName()});
        }
    }

    protected void log(LogType log, Mapping mapping) {
        if (null != mapping) {
            String model = ModelEnum.getModelEnum((String)mapping.getModel()).getName();
            this.logService.log(log, "%s%s:%s(%s)", new Object[]{log.getMessage(), log.getName(), mapping.getName(), model});
        }
    }

    protected void log(LogType log, TableGroup tableGroup) {
        Mapping mapping;
        if (null != tableGroup && null != (mapping = this.profileComponent.getMapping(tableGroup.getMappingId()))) {
            String name = mapping.getName();
            String model = ModelEnum.getModelEnum((String)mapping.getModel()).getName();
            String s = tableGroup.getSourceTable().getName();
            String t = tableGroup.getTargetTable().getName();
            this.logService.log(log, "%s\u9a71\u52a8%s(%s)%s:[%s] >> [%s]", new Object[]{log.getMessage(), name, model, log.getName(), s, t});
        }
    }

    protected void sendNotifyMessage(String title, String content) {
        this.messageService.sendMessage(title, content);
    }
}

