/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dbsyncer.biz.BizException;
import org.dbsyncer.biz.ConnectorService;
import org.dbsyncer.biz.checker.Checker;
import org.dbsyncer.biz.impl.BaseServiceImpl;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.base.ConnectorFactory;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Connector;
import org.dbsyncer.sdk.model.ConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ConnectorServiceImpl
extends BaseServiceImpl
implements ConnectorService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, Boolean> health = new LinkedHashMap<String, Boolean>();
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private ConnectorFactory connectorFactory;
    @Resource
    private LogService logService;
    @Resource
    private Checker connectorChecker;

    @Override
    public String add(Map<String, String> params) {
        ConfigModel model = this.connectorChecker.checkAddConfigModel(params);
        this.log((LogType)LogType.ConnectorLog.INSERT, model);
        return this.profileComponent.addConfigModel(model);
    }

    @Override
    public String copy(String id) {
        Connector connector = this.getConnector(id);
        Assert.notNull((Object)connector, (String)"The connector id is invalid.");
        Map params = JsonUtil.parseMap((Object)connector.getConfig());
        params.put("name", connector.getName() + "(\u590d\u5236)");
        ConfigModel model = this.connectorChecker.checkAddConfigModel(params);
        this.log((LogType)LogType.ConnectorLog.COPY, model);
        this.profileComponent.addConfigModel(model);
        return String.format("\u590d\u5236\u6210\u529f[%s]", model.getName());
    }

    @Override
    public String edit(Map<String, String> params) {
        ConfigModel model = this.connectorChecker.checkEditConfigModel(params);
        this.log((LogType)LogType.ConnectorLog.UPDATE, model);
        return this.profileComponent.editConfigModel(model);
    }

    @Override
    public String remove(String id) {
        Connector connector;
        List mappingAll = this.profileComponent.getMappingAll();
        if (!CollectionUtils.isEmpty((Collection)mappingAll)) {
            mappingAll.forEach(mapping -> {
                if (StringUtil.equals((CharSequence)mapping.getSourceConnectorId(), (CharSequence)id) || StringUtil.equals((CharSequence)mapping.getTargetConnectorId(), (CharSequence)id)) {
                    String error = String.format("\u9a71\u52a8\u201c%s\u201d\u6b63\u5728\u4f7f\u7528\uff0c\u8bf7\u5148\u5220\u9664", mapping.getName());
                    this.logger.error(error);
                    throw new BizException(error);
                }
            });
        }
        if ((connector = this.profileComponent.getConnector(id)) != null) {
            this.connectorFactory.disconnect(connector.getConfig());
            this.log((LogType)LogType.ConnectorLog.DELETE, (ConfigModel)connector);
            this.profileComponent.removeConfigModel(id);
        }
        return "\u5220\u9664\u8fde\u63a5\u5668\u6210\u529f!";
    }

    @Override
    public Connector getConnector(String id) {
        return StringUtil.isNotBlank((CharSequence)id) ? this.profileComponent.getConnector(id) : null;
    }

    @Override
    public List<Connector> getConnectorAll() {
        List<Connector> list = this.profileComponent.getConnectorAll().stream().sorted(Comparator.comparing(ConfigModel::getUpdateTime).reversed()).collect(Collectors.toList());
        return list;
    }

    @Override
    public List<String> getConnectorTypeAll() {
        ArrayList<String> connectorTypes = new ArrayList<String>(this.connectorFactory.getConnectorTypeAll());
        Collections.sort(connectorTypes, Comparator.comparing(String::toString));
        return connectorTypes;
    }

    @Override
    public void refreshHealth() {
        List list = this.profileComponent.getConnectorAll();
        if (CollectionUtils.isEmpty((Collection)list)) {
            if (!CollectionUtils.isEmpty(this.health)) {
                this.health.clear();
            }
            return;
        }
        HashSet exist = new HashSet();
        list.forEach(c -> {
            this.health.put(c.getId(), this.isAlive(c.getConfig()));
            exist.add(c.getId());
        });
        HashSet remove = new HashSet();
        this.health.keySet().forEach(k -> {
            if (!exist.contains(k)) {
                remove.add(k);
            }
        });
        if (!CollectionUtils.isEmpty(remove)) {
            remove.forEach(k -> this.health.remove(k));
        }
    }

    @Override
    public boolean isAlive(String id) {
        return this.health.containsKey(id) && this.health.get(id) != false;
    }

    private boolean isAlive(ConnectorConfig config) {
        try {
            return this.connectorFactory.isAlive(config);
        }
        catch (Exception e) {
            LogType.ConnectorLog logType = LogType.ConnectorLog.FAILED;
            this.logService.log((LogType)logType, "%s%s", new Object[]{logType.getName(), e.getMessage()});
            return false;
        }
    }
}

