/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dbsyncer.biz.DataSyncService;
import org.dbsyncer.biz.vo.BinlogColumnVo;
import org.dbsyncer.biz.vo.MessageVo;
import org.dbsyncer.common.model.Paging;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.DateFormatUtil;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.NumberUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.flush.impl.BufferActuatorRouter;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.Picker;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.filter.FieldResolver;
import org.dbsyncer.sdk.filter.Query;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.storage.StorageService;
import org.dbsyncer.storage.binlog.proto.BinlogMap;
import org.dbsyncer.storage.util.BinlogMessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class DataSyncServiceImpl
implements DataSyncService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private BufferActuatorRouter bufferActuatorRouter;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private StorageService storageService;

    @Override
    public MessageVo getMessageVo(String metaId, String messageId) {
        Assert.hasText((String)metaId, (String)"The metaId is null.");
        Assert.hasText((String)messageId, (String)"The messageId is null.");
        MessageVo messageVo = new MessageVo();
        try {
            Map row = this.getData(metaId, messageId);
            Map binlogData = this.getBinlogData(row, true);
            String tableGroupId = (String)row.get("tableGroupId");
            TableGroup tableGroup = this.profileComponent.getTableGroup(tableGroupId);
            messageVo.setSourceTableName(tableGroup.getSourceTable().getName());
            messageVo.setTargetTableName(tableGroup.getTargetTable().getName());
            messageVo.setId(messageId);
            if (!CollectionUtils.isEmpty((Map)binlogData)) {
                Map<String, String> columnMap = tableGroup.getTargetTable().getColumn().stream().collect(Collectors.toMap(Field::getName, Field::getTypeName));
                ArrayList<BinlogColumnVo> columns = new ArrayList<BinlogColumnVo>();
                binlogData.forEach((k, v) -> columns.add(new BinlogColumnVo((String)k, v, (String)columnMap.get(k))));
                messageVo.setColumns(columns);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return messageVo;
    }

    @Override
    public Map getBinlogData(Map row, boolean prettyBytes) throws InvalidProtocolBufferException {
        String tableGroupId = (String)row.get("tableGroupId");
        TableGroup tableGroup = this.profileComponent.getTableGroup(tableGroupId);
        if (tableGroup == null) {
            return Collections.EMPTY_MAP;
        }
        byte[] bytes = (byte[])row.get("data");
        if (null == bytes) {
            if (prettyBytes) {
                String json = (String)row.get("json");
                return JsonUtil.parseMap((String)json);
            }
            return Collections.EMPTY_MAP;
        }
        HashMap target = new HashMap();
        Picker picker = new Picker(tableGroup.getFieldMapping());
        Map fieldMap = picker.getTargetFieldMap();
        BinlogMap message = BinlogMap.parseFrom((byte[])bytes);
        message.getRowMap().forEach((k, v) -> {
            if (fieldMap.containsKey(k)) {
                try {
                    Object val = BinlogMessageUtil.deserializeValue((int)((Field)fieldMap.get(k)).getType(), (ByteString)v);
                    if (prettyBytes && null != val && val instanceof byte[]) {
                        byte[] b = (byte[])val;
                        if (b.length > 128) {
                            target.put(k, String.format("byte[%d]", b.length));
                            return;
                        }
                        target.put(k, Arrays.toString(b));
                        return;
                    }
                    target.put(k, val);
                }
                catch (Exception e) {
                    this.logger.warn("\u89e3\u6790Binlog\u6570\u636e\u7c7b\u578b\u5f02\u5e38\uff1atype=[{}], valueType=[{}], value=[{}]", new Object[]{((Field)fieldMap.get(k)).getType(), v == null ? null : v.getClass().getName(), v});
                }
            }
        });
        return target;
    }

    @Override
    public String sync(Map<String, String> params) throws InvalidProtocolBufferException {
        String metaId = params.get("metaId");
        String messageId = params.get("messageId");
        Assert.hasText((String)metaId, (String)"The metaId is null.");
        Assert.hasText((String)messageId, (String)"The messageId is null.");
        Map row = this.getData(metaId, messageId);
        Map binlogData = this.getBinlogData(row, false);
        if (CollectionUtils.isEmpty((Map)binlogData)) {
            return messageId;
        }
        String tableGroupId = (String)row.get("tableGroupId");
        String event = (String)row.get("event");
        String retryDataParams = params.get("retryDataParams");
        if (StringUtil.isNotBlank((CharSequence)retryDataParams)) {
            JsonUtil.parseMap((String)retryDataParams).forEach((k, v) -> binlogData.put(k, this.convertValue(binlogData.get(k), (String)v)));
        }
        TableGroup tableGroup = this.profileComponent.getTableGroup(tableGroupId);
        String sourceTableName = tableGroup.getSourceTable().getName();
        RowChangedEvent changedEvent = new RowChangedEvent(sourceTableName, event, Collections.EMPTY_LIST);
        Picker picker = new Picker(tableGroup.getFieldMapping());
        changedEvent.setChangedRow(picker.pickSourceData(binlogData));
        this.bufferActuatorRouter.execute(metaId, tableGroupId, (ChangedEvent)changedEvent);
        this.storageService.remove(StorageEnum.DATA, metaId, messageId);
        Meta meta = this.profileComponent.getMeta(metaId);
        Assert.notNull((Object)meta, (String)"Meta can not be null.");
        meta.getFail().decrementAndGet();
        meta.setUpdateTime(Long.valueOf(Instant.now().toEpochMilli()));
        this.profileComponent.editConfigModel((ConfigModel)meta);
        return messageId;
    }

    private Map getData(String metaId, String messageId) {
        Query query = new Query(1, 1);
        LinkedHashMap<String, FieldResolver> fieldResolvers = new LinkedHashMap<String, FieldResolver>();
        fieldResolvers.put("data", field -> field.binaryValue().bytes);
        query.setFieldResolverMap(fieldResolvers);
        query.addFilter("id", messageId);
        query.setMetaId(metaId);
        query.setType(StorageEnum.DATA);
        Paging paging = this.storageService.query(query);
        if (!CollectionUtils.isEmpty((Collection)paging.getData())) {
            List data = (List)paging.getData();
            return (Map)data.get(0);
        }
        return Collections.EMPTY_MAP;
    }

    private Object convertValue(Object oldValue, String newValue) {
        Object newVal;
        String type;
        if (oldValue == null) {
            return newValue;
        }
        switch (type = oldValue.getClass().getName()) {
            case "java.sql.Date": {
                newVal = DateFormatUtil.stringToDate((String)newValue);
                break;
            }
            case "java.sql.Timestamp": {
                newVal = DateFormatUtil.stringToTimestamp((String)newValue);
                break;
            }
            case "java.lang.Integer": 
            case "java.lang.Short": {
                newVal = NumberUtil.toInt((String)newValue);
                break;
            }
            case "java.lang.Long": {
                newVal = NumberUtil.toLong((String)newValue);
                break;
            }
            case "java.lang.Float": {
                newVal = Float.valueOf(newValue);
                break;
            }
            case "java.lang.Double": {
                newVal = Double.valueOf(newValue);
                break;
            }
            case "[B": {
                newVal = this.stringToBytes(newValue);
                break;
            }
            default: {
                newVal = newValue;
            }
        }
        return newVal;
    }

    private byte[] stringToBytes(String s) {
        byte[] b = null;
        if (s.startsWith("[") && s.endsWith("]")) {
            s = StringUtil.substring((String)s, (int)1, (int)(s.length() - 1));
            String[] split = StringUtil.split((String)s, (String)",");
            int length = split.length;
            b = new byte[length];
            for (int i = 0; i < length; ++i) {
                b[i] = Byte.valueOf(split[i].trim());
            }
        }
        return b;
    }
}

