/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.dbsyncer.biz.enums.BufferActuatorMetricEnum;
import org.dbsyncer.biz.enums.StatisticEnum;
import org.dbsyncer.biz.enums.ThreadPoolMetricEnum;
import org.dbsyncer.biz.model.AppReportMetric;
import org.dbsyncer.biz.model.MappingReportMetric;
import org.dbsyncer.biz.model.MetricResponse;
import org.dbsyncer.biz.model.MetricResponseInfo;
import org.dbsyncer.biz.model.Sample;
import org.dbsyncer.common.model.Paging;
import org.dbsyncer.common.scheduled.ScheduledTaskJob;
import org.dbsyncer.common.scheduled.ScheduledTaskService;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.flush.BufferActuator;
import org.dbsyncer.parser.flush.impl.BufferActuatorRouter;
import org.dbsyncer.parser.flush.impl.TableGroupBufferActuator;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.filter.Query;
import org.dbsyncer.sdk.storage.StorageService;
import org.dbsyncer.storage.enums.StorageDataStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class MetricReporter
implements ScheduledTaskJob {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private BufferActuator generalBufferActuator;
    @Resource
    private BufferActuator storageBufferActuator;
    @Resource
    private BufferActuatorRouter bufferActuatorRouter;
    @Resource
    private ScheduledTaskService scheduledTaskService;
    @Resource
    private StorageService storageService;
    private volatile boolean running;
    private LocalDateTime queryTime;
    private final MappingReportMetric mappingReportMetric = new MappingReportMetric();
    private final int SHOW_BUFFER_ACTUATOR_SIZE = 6;

    @PostConstruct
    private void init() {
        this.scheduledTaskService.start(5000L, (ScheduledTaskJob)this);
    }

    public List<MetricResponse> getMetricInfo() {
        ArrayList<MetricResponseInfo> list = new ArrayList<MetricResponseInfo>();
        BufferActuatorMetricEnum general = BufferActuatorMetricEnum.GENERAL;
        BufferActuatorMetricEnum storage = BufferActuatorMetricEnum.STORAGE;
        list.add(this.collect(this.generalBufferActuator, general.getCode(), general.getGroup(), general.getMetricName()));
        list.add(this.collect(this.storageBufferActuator, storage.getCode(), storage.getGroup(), storage.getMetricName()));
        if (!CollectionUtils.isEmpty((Map)this.bufferActuatorRouter.getRouter())) {
            ArrayList tableList = new ArrayList();
            String tableGroupCode = BufferActuatorMetricEnum.TABLE_GROUP.getCode();
            this.bufferActuatorRouter.getRouter().forEach((metaId, group) -> {
                Meta meta = this.profileComponent.getMeta(metaId);
                Mapping mapping = this.profileComponent.getMapping(meta.getMappingId());
                group.forEach((k, bufferActuator) -> {
                    if (bufferActuator instanceof TableGroupBufferActuator) {
                        TableGroupBufferActuator actuator = bufferActuator;
                        TableGroup tableGroup = this.profileComponent.getTableGroup(actuator.getTableGroupId());
                        String metricName = tableGroup.getSourceTable().getName() + " > " + tableGroup.getTargetTable().getName();
                        tableList.add(this.collect((BufferActuator)bufferActuator, tableGroupCode, mapping.getName(), metricName));
                    }
                });
            });
            List sortList = tableList.stream().sorted(Comparator.comparing(MetricResponseInfo::getQueueUp).reversed()).collect(Collectors.toList());
            list.addAll(sortList.size() <= 6 ? sortList : sortList.subList(0, 6));
        }
        return list.stream().map(info -> info.getResponse()).collect(Collectors.toList());
    }

    public AppReportMetric getAppReportMetric() {
        this.queryTime = LocalDateTime.now();
        AppReportMetric report = new AppReportMetric();
        report.setSuccess(this.mappingReportMetric.getSuccess());
        report.setFail(this.mappingReportMetric.getFail());
        report.setInsert(this.mappingReportMetric.getInsert());
        report.setUpdate(this.mappingReportMetric.getUpdate());
        report.setDelete(this.mappingReportMetric.getDelete());
        report.setQueueUp(this.bufferActuatorRouter.getQueueSize().addAndGet(this.generalBufferActuator.getQueue().size()));
        report.setQueueCapacity(this.bufferActuatorRouter.getQueueCapacity().addAndGet(this.generalBufferActuator.getQueueCapacity()));
        report.setStorageQueueUp(this.storageBufferActuator.getQueue().size());
        report.setStorageQueueCapacity(this.storageBufferActuator.getQueueCapacity());
        return report;
    }

    public void run() {
        if (this.running || null == this.queryTime) {
            return;
        }
        if (LocalDateTime.now().minusSeconds(30L).isAfter(this.queryTime)) {
            return;
        }
        try {
            this.running = true;
            List metaAll = this.profileComponent.getMetaAll();
            this.mappingReportMetric.setSuccess(this.getMappingSuccess(metaAll));
            this.mappingReportMetric.setFail(this.getMappingFail(metaAll));
            this.mappingReportMetric.setInsert(this.getMappingInsert(metaAll));
            this.mappingReportMetric.setUpdate(this.getMappingUpdate(metaAll));
            this.mappingReportMetric.setDelete(this.getMappingDelete(metaAll));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        finally {
            this.running = false;
        }
    }

    private long getMappingSuccess(List<Meta> metaAll) {
        return this.queryMappingMetricCount(metaAll, query -> query.addFilter("success", StorageDataStatusEnum.SUCCESS.getValue().intValue()));
    }

    private long getMappingFail(List<Meta> metaAll) {
        return this.queryMappingMetricCount(metaAll, query -> query.addFilter("success", StorageDataStatusEnum.FAIL.getValue().intValue()));
    }

    private long getMappingInsert(List<Meta> metaAll) {
        return this.queryMappingMetricCount(metaAll, query -> query.addFilter("event", "INSERT"));
    }

    private long getMappingUpdate(List<Meta> metaAll) {
        return this.queryMappingMetricCount(metaAll, query -> query.addFilter("event", "UPDATE"));
    }

    private long getMappingDelete(List<Meta> metaAll) {
        return this.queryMappingMetricCount(metaAll, query -> query.addFilter("event", "DELETE"));
    }

    private long queryMappingMetricCount(List<Meta> metaAll, Consumer<Query> operation) {
        AtomicLong total = new AtomicLong(0L);
        if (!CollectionUtils.isEmpty(metaAll)) {
            Query query = new Query(1, 1);
            query.setQueryTotal(true);
            query.setType(StorageEnum.DATA);
            operation.accept(query);
            metaAll.forEach(meta -> {
                query.setMetaId(meta.getId());
                Paging paging = this.storageService.query(query);
                total.getAndAdd(paging.getTotal());
            });
        }
        return total.get();
    }

    private MetricResponseInfo collect(BufferActuator bufferActuator, String code, String group, String metricName) {
        MetricResponseInfo info = new MetricResponseInfo();
        ThreadPoolTaskExecutor threadTask = (ThreadPoolTaskExecutor)bufferActuator.getExecutor();
        ThreadPoolExecutor pool = threadTask.getThreadPoolExecutor();
        info.setQueueUp(bufferActuator.getQueue().size());
        StringBuilder msg = new StringBuilder();
        msg.append("\u5806\u79ef").append(":").append(info.getQueueUp());
        msg.append("/").append(bufferActuator.getQueueCapacity()).append(" ");
        msg.append(ThreadPoolMetricEnum.CORE_SIZE.getMetricName()).append(":").append(pool.getActiveCount());
        msg.append("/").append(pool.getMaximumPoolSize()).append(" ");
        msg.append(ThreadPoolMetricEnum.COMPLETED.getMetricName()).append(":").append(pool.getCompletedTaskCount());
        info.setResponse(new MetricResponse(code, group, metricName, Arrays.asList(new Sample(StatisticEnum.COUNT.getTagValueRepresentation(), msg.toString()))));
        return info;
    }
}

