/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.dbsyncer.biz.SystemConfigService;
import org.dbsyncer.biz.UserConfigService;
import org.dbsyncer.biz.checker.Checker;
import org.dbsyncer.biz.vo.SystemConfigVo;
import org.dbsyncer.common.enums.FileSuffixEnum;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.manager.impl.PreloadTemplate;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.SystemConfig;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SystemConfigServiceImpl
implements SystemConfigService {
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private PreloadTemplate preloadTemplate;
    @Resource
    private Checker systemConfigChecker;
    @Resource
    private LogService logService;
    @Resource
    private UserConfigService userConfigService;

    @Override
    public String edit(Map<String, String> params) {
        ConfigModel model = this.systemConfigChecker.checkEditConfigModel(params);
        this.profileComponent.editConfigModel(model);
        return "\u4fee\u6539\u6210\u529f.";
    }

    @Override
    public SystemConfigVo getSystemConfigVo() {
        return this.convertConfig2Vo(this.getSystemConfig());
    }

    @Override
    public List<ConfigModel> getConfigModelAll() {
        ArrayList<ConfigModel> list = new ArrayList<ConfigModel>();
        list.add((ConfigModel)this.getSystemConfig());
        list.add((ConfigModel)this.userConfigService.getUserConfig());
        this.profileComponent.getConnectorAll().forEach(config -> list.add((ConfigModel)config));
        this.profileComponent.getMappingAll().forEach(config -> list.add((ConfigModel)config));
        this.profileComponent.getMetaAll().forEach(config -> list.add((ConfigModel)config));
        return list;
    }

    @Override
    public void checkFileSuffix(String filename) {
        Assert.hasText((String)filename, (String)"the config filename is null.");
        String suffix = filename.substring(filename.lastIndexOf(".") + 1, filename.length());
        FileSuffixEnum fileSuffix = FileSuffixEnum.getFileSuffix((String)suffix);
        Assert.notNull((Object)fileSuffix, (String)"Illegal file suffix");
        Assert.isTrue((FileSuffixEnum.JSON == fileSuffix ? 1 : 0) != 0, (String)String.format("\u4e0d\u6b63\u786e\u7684\u6587\u4ef6\u6269\u5c55\u540d \"%s\"\uff0c\u53ea\u652f\u6301 \"%s\" \u7684\u6587\u4ef6\u6269\u5c55\u540d\u3002", filename, FileSuffixEnum.JSON.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshConfig(File file) {
        Assert.notNull((Object)file, (String)"the config file is null.");
        try {
            List lines = FileUtils.readLines((File)file, (Charset)Charset.defaultCharset());
            if (!CollectionUtils.isEmpty((Collection)lines)) {
                StringBuilder json = new StringBuilder();
                lines.forEach(line -> json.append((String)line));
                this.preloadTemplate.reload(json.toString());
            }
        }
        catch (IOException e) {
            this.logService.log((LogType)LogType.CacheLog.IMPORT_ERROR);
        }
        finally {
            FileUtils.deleteQuietly((File)file);
        }
    }

    @Override
    public boolean isEnableCDN() {
        return this.getSystemConfig().isEnableCDN();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SystemConfig getSystemConfig() {
        SystemConfig config = this.profileComponent.getSystemConfig();
        if (null != config) {
            return config;
        }
        SystemConfigServiceImpl systemConfigServiceImpl = this;
        synchronized (systemConfigServiceImpl) {
            config = this.profileComponent.getSystemConfig();
            if (null == config) {
                config = (SystemConfig)this.systemConfigChecker.checkAddConfigModel(new HashMap<String, String>());
            }
            return config;
        }
    }

    private SystemConfigVo convertConfig2Vo(SystemConfig systemConfig) {
        SystemConfigVo systemConfigVo = new SystemConfigVo();
        BeanUtils.copyProperties((Object)systemConfig, (Object)((Object)systemConfigVo));
        return systemConfigVo;
    }
}

