/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.sqlserver.cdc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.dbsyncer.connector.sqlserver.cdc.Lsn;
import org.dbsyncer.connector.sqlserver.cdc.SqlServerListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LsnPuller {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long DEFAULT_POLL_INTERVAL_MILLIS = 100L;
    private static volatile LsnPuller instance = null;
    private final Map<String, SqlServerListener> map = new ConcurrentHashMap<String, SqlServerListener>();
    private Worker worker;

    private LsnPuller() {
        this.initWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LsnPuller getInstance() {
        if (instance != null) return instance;
        Class<LsnPuller> clazz = LsnPuller.class;
        synchronized (LsnPuller.class) {
            if (instance != null) return instance;
            instance = new LsnPuller();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initWorker() {
        this.worker = new Worker();
        this.worker.setName("cdc-LsnPuller");
        this.worker.setDaemon(false);
        this.worker.start();
    }

    public static void addExtractor(String metaId, SqlServerListener listener) {
        LsnPuller.getInstance().map.put(metaId, listener);
    }

    public static void removeExtractor(String metaId) {
        LsnPuller.getInstance().map.remove(metaId);
    }

    final class Worker
    extends Thread {
        Worker() {
        }

        @Override
        public void run() {
            while (!this.isInterrupted()) {
                try {
                    if (LsnPuller.this.map.isEmpty()) {
                        TimeUnit.SECONDS.sleep(1L);
                        continue;
                    }
                    Lsn maxLsn = null;
                    for (SqlServerListener listener : LsnPuller.this.map.values()) {
                        maxLsn = listener.getMaxLsn();
                        if (null == maxLsn || !maxLsn.isAvailable() || maxLsn.compareTo(listener.getLastLsn()) <= 0) continue;
                        listener.pushStopLsn(maxLsn);
                    }
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (Exception e) {
                    LsnPuller.this.logger.error("\u5f02\u5e38", (Throwable)e);
                    try {
                        TimeUnit.SECONDS.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        LsnPuller.this.logger.warn(ex.getMessage());
                    }
                }
            }
        }
    }
}

