/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.plugin;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.apache.commons.io.FileUtils;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.plugin.model.Plugin;
import org.dbsyncer.sdk.plugin.PluginContext;
import org.dbsyncer.sdk.spi.PluginService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class PluginFactory
implements DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String PLUGIN_PATH = System.getProperty("user.dir") + File.separatorChar + "plugins" + File.separatorChar;
    private final String LIBRARY_PATH = System.getProperty("user.dir") + File.separatorChar + "lib" + File.separatorChar;
    private final List<Plugin> plugins = new LinkedList<Plugin>();
    private final Map<String, PluginService> service = new LinkedHashMap<String, PluginService>();
    @Resource
    private ApplicationContext applicationContext;

    @PostConstruct
    private void init() {
        Map services = this.applicationContext.getBeansOfType(PluginService.class);
        if (!CollectionUtils.isEmpty((Map)services)) {
            services.forEach((k, s) -> {
                String pluginId = this.createPluginId(s.getClass().getName(), s.getVersion());
                this.service.putIfAbsent(pluginId, (PluginService)s);
                this.plugins.add(new Plugin(s.getName(), s.getClass().getName(), s.getVersion(), "", true));
                this.logger.info("{}_{} {}", new Object[]{s.getName(), s.getVersion(), s.getClass().getName()});
                try {
                    s.init();
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            });
        }
    }

    public synchronized void loadPlugins() {
        if (!CollectionUtils.isEmpty(this.plugins)) {
            List unmodifiablePlugin = this.plugins.stream().filter(p -> p.isUnmodifiable()).collect(Collectors.toList());
            this.plugins.clear();
            this.plugins.addAll(unmodifiablePlugin);
        }
        try {
            FileUtils.forceMkdir((File)new File(this.PLUGIN_PATH));
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
        }
        Collection files = FileUtils.listFiles((File)new File(this.PLUGIN_PATH), (String[])new String[]{"jar"}, (boolean)true);
        if (!CollectionUtils.isEmpty((Collection)files)) {
            files.forEach(f -> this.loadPlugin((File)f));
        }
        this.logger.info("PreLoad plugin:{}", (Object)this.plugins.size());
    }

    public String getPluginPath() {
        return this.PLUGIN_PATH;
    }

    public String getLibraryPath() {
        return this.LIBRARY_PATH;
    }

    public List<Plugin> getPluginAll() {
        return Collections.unmodifiableList(this.plugins);
    }

    public void convert(Plugin plugin, PluginContext context) {
        if (null != plugin) {
            String pluginId = this.createPluginId(plugin.getClassName(), plugin.getVersion());
            this.service.computeIfPresent(pluginId, (k, c) -> {
                c.convert(context);
                return c;
            });
        }
    }

    public void postProcessAfter(Plugin plugin, PluginContext context) {
        if (null != plugin) {
            String pluginId = this.createPluginId(plugin.getClassName(), plugin.getVersion());
            this.service.computeIfPresent(pluginId, (k, c) -> {
                c.postProcessAfter(context);
                return c;
            });
        }
    }

    public String createPluginId(String pluginClassName, String pluginVersion) {
        return pluginClassName + "_" + pluginVersion;
    }

    private void loadPlugin(File jar) {
        try {
            String fileName = jar.getName();
            URL url = jar.toURI().toURL();
            URLClassLoader loader = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            ServiceLoader<PluginService> services = ServiceLoader.load(PluginService.class, loader);
            for (PluginService s : services) {
                String pluginId = this.createPluginId(s.getClass().getName(), s.getVersion());
                if (this.service.containsKey(pluginId)) {
                    try {
                        this.service.get(pluginId).close();
                    }
                    catch (Exception e) {
                        this.logger.error(e.getMessage(), (Throwable)e);
                    }
                    this.service.remove(pluginId);
                }
                this.service.putIfAbsent(pluginId, s);
                this.plugins.add(new Plugin(s.getName(), s.getClass().getName(), s.getVersion(), fileName, false));
                this.logger.info("{}, {}_{} {}", new Object[]{fileName, s.getName(), s.getVersion(), s.getClass().getName()});
                try {
                    s.init();
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (MalformedURLException e) {
            this.logger.error(e.getMessage());
        }
    }

    public void destroy() {
        this.service.values().forEach(s -> {
            this.logger.info("{}_{} {}", new Object[]{s.getName(), s.getVersion(), s.getClass().getName()});
            try {
                s.close();
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        });
        this.service.clear();
    }
}

