/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.elasticsearch;

import org.dbsyncer.connector.elasticsearch.api.EasyRestHighLevelClient;
import org.dbsyncer.connector.elasticsearch.config.ESConfig;
import org.dbsyncer.connector.elasticsearch.util.ESUtil;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.core.MainResponse;

public final class ESConnectorInstance
implements ConnectorInstance<ESConfig, EasyRestHighLevelClient> {
    private ESConfig config;
    private EasyRestHighLevelClient client;

    public ESConnectorInstance(ESConfig config) {
        this.config = config;
        this.client = ESUtil.getConnection(config);
        try {
            MainResponse info = this.client.info(RequestOptions.DEFAULT);
            this.client.setVersion(Version.fromString((String)info.getVersion().getNumber()));
        }
        catch (Exception e) {
            throw new ElasticsearchException(String.format("\u83b7\u53d6ES\u7248\u672c\u4fe1\u606f\u5f02\u5e38 %s, %s", config.getUrl(), e.getMessage()), new Object[0]);
        }
    }

    public String getServiceUrl() {
        return this.config.getUrl();
    }

    public ESConfig getConfig() {
        return this.config;
    }

    public void setConfig(ESConfig config) {
        this.config = config;
    }

    public EasyRestHighLevelClient getConnection() {
        return this.client;
    }

    public Version getVersion() {
        return this.client.getVersion();
    }

    public void close() {
        ESUtil.close(this.client);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

