/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.elasticsearch.api;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.dbsyncer.connector.elasticsearch.api.RequestConverters;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.script.mustache.SearchTemplateRequest;
import org.elasticsearch.script.mustache.SearchTemplateResponse;

public final class EasyRestHighLevelClient
extends RestHighLevelClient {
    private Version version;

    public EasyRestHighLevelClient(RestClientBuilder restClientBuilder) {
        super(restClientBuilder);
    }

    protected EasyRestHighLevelClient(RestClientBuilder restClientBuilder, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        super(restClientBuilder, namedXContentEntries);
    }

    protected EasyRestHighLevelClient(RestClient restClient, CheckedConsumer<RestClient, IOException> doClose, List<NamedXContentRegistry.Entry> namedXContentEntries) {
        super(restClient, doClose, namedXContentEntries);
    }

    public final BulkResponse bulkWithVersion(BulkRequest bulkRequest, RequestOptions options) throws IOException {
        return (BulkResponse)this.performRequestAndParseEntity((ActionRequest)bulkRequest, RequestConverters::bulk, options, BulkResponse::fromXContent, Collections.emptySet());
    }

    public final SearchResponse searchWithVersion(SearchRequest searchRequest, RequestOptions options) throws IOException {
        return (SearchResponse)this.performRequestAndParseEntity((ActionRequest)searchRequest, r -> RequestConverters.search(r, "_search", this.version), options, SearchResponse::fromXContent, Collections.emptySet());
    }

    public final SearchTemplateResponse searchTemplateWithVersion(SearchTemplateRequest searchTemplateRequest, RequestOptions options) throws IOException {
        return (SearchTemplateResponse)this.performRequestAndParseEntity((ActionRequest)searchTemplateRequest, r -> RequestConverters.searchTemplate(r, this.version), options, SearchTemplateResponse::fromXContent, Collections.emptySet());
    }

    public final Cancellable searchTemplateAsyncWithVersion(SearchTemplateRequest searchTemplateRequest, RequestOptions options, ActionListener<SearchTemplateResponse> listener) {
        return this.performRequestAsyncAndParseEntity((ActionRequest)searchTemplateRequest, r -> RequestConverters.searchTemplate(r, this.version), options, SearchTemplateResponse::fromXContent, listener, Collections.emptySet());
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }
}

