/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.elasticsearch.enums;

import org.dbsyncer.common.util.StringUtil;
import org.elasticsearch.ElasticsearchException;

public enum ESFieldTypeEnum {
    KEYWORD("keyword", 12),
    TEXT("text", -1),
    STRING("string", 12),
    INTEGER("integer", 4),
    LONG("long", -5),
    SHORT("short", -6),
    BYTE("byte", -7),
    DOUBLE("double", 8),
    FLOAT("float", 6),
    HALF_FLOAT("half_float", 6),
    SCALED_FLOAT("scaled_float", 6),
    BOOLEAN("boolean", 16),
    DATE("date", 91),
    INTEGER_RANGE("integer_range", 4),
    FLOAT_RANGE("float_range", 6),
    LONG_RANGE("long_range", -5),
    DOUBLE_RANGE("double_range", 8),
    DATE_RANGE("date_range", 91),
    NESTED("nested", 1111),
    OBJECT("object", 12),
    IP("ip", 12),
    TOKEN_COUNT("token_count", -5),
    GEO_POINT("geo_point", 12),
    GEO_SHAPE("geo_shape", 12),
    BINARY("binary", -2);

    private String code;
    private int type;

    private ESFieldTypeEnum(String code, int type) {
        this.code = code;
        this.type = type;
    }

    public static int getType(String code) throws ElasticsearchException {
        for (ESFieldTypeEnum e : ESFieldTypeEnum.values()) {
            if (!StringUtil.equals((CharSequence)e.getCode(), (CharSequence)code)) continue;
            return e.getType();
        }
        return 12;
    }

    public String getCode() {
        return this.code;
    }

    public int getType() {
        return this.type;
    }
}

