/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.elasticsearch.util;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.elasticsearch.api.EasyRestHighLevelClient;
import org.dbsyncer.connector.elasticsearch.config.ESConfig;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;

public abstract class ESUtil {
    public static final String PROPERTIES = "properties";

    private ESUtil() {
    }

    public static EasyRestHighLevelClient getConnection(ESConfig config) {
        String[] ipAddress = StringUtil.split((String)config.getUrl(), (String)",");
        HttpHost[] hosts = (HttpHost[])Arrays.stream(ipAddress).map(node -> HttpHost.create((String)node)).filter(Objects::nonNull).toArray(HttpHost[]::new);
        RestClientBuilder builder = RestClient.builder((HttpHost[])hosts);
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(config.getUsername(), config.getPassword()));
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
            SSLIOSessionStrategy sessionStrategy = new SSLIOSessionStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            builder.setHttpClientConfigCallback(arg_0 -> ESUtil.lambda$getConnection$2((CredentialsProvider)credentialsProvider, sessionStrategy, arg_0));
            EasyRestHighLevelClient client = new EasyRestHighLevelClient(builder);
            client.ping(RequestOptions.DEFAULT);
            return client;
        }
        catch (Exception e) {
            throw new ElasticsearchException(String.format("Failed to connect to ElasticSearch on %s, %s", config.getUrl(), e.getMessage()), new Object[0]);
        }
    }

    public static void close(RestHighLevelClient client) {
        if (null != client) {
            try {
                client.close();
            }
            catch (IOException e) {
                throw new ElasticsearchException(e.getMessage(), new Object[0]);
            }
        }
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getConnection$2(CredentialsProvider credentialsProvider, SSLIOSessionStrategy sessionStrategy, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider).setSSLStrategy((SchemeIOSessionStrategy)sessionStrategy);
    }
}

