/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.mysql.binlog;

import com.github.shyiko.mysql.binlog.GtidSet;
import com.github.shyiko.mysql.binlog.MariadbGtidSet;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventData;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.deserialization.AnnotateRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.ChecksumType;
import com.github.shyiko.mysql.binlog.event.deserialization.DeleteRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventHeaderDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.EventHeaderV4Deserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.FormatDescriptionEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.GtidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.IntVarEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.MariadbGtidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.MariadbGtidListEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.NullEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.PreviousGtidSetDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.QueryEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.RotateEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.RowsQueryEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.TableMapEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.UpdateRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.WriteRowsEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.XAPrepareEventDataDeserializer;
import com.github.shyiko.mysql.binlog.event.deserialization.XidEventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import com.github.shyiko.mysql.binlog.network.Authenticator;
import com.github.shyiko.mysql.binlog.network.DefaultSSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.SSLMode;
import com.github.shyiko.mysql.binlog.network.SSLSocketFactory;
import com.github.shyiko.mysql.binlog.network.ServerException;
import com.github.shyiko.mysql.binlog.network.TLSHostnameVerifier;
import com.github.shyiko.mysql.binlog.network.protocol.ErrorPacket;
import com.github.shyiko.mysql.binlog.network.protocol.GreetingPacket;
import com.github.shyiko.mysql.binlog.network.protocol.PacketChannel;
import com.github.shyiko.mysql.binlog.network.protocol.ResultSetRowPacket;
import com.github.shyiko.mysql.binlog.network.protocol.command.Command;
import com.github.shyiko.mysql.binlog.network.protocol.command.DumpBinaryLogCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.DumpBinaryLogGtidCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.PingCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.QueryCommand;
import com.github.shyiko.mysql.binlog.network.protocol.command.SSLRequestCommand;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.dbsyncer.connector.mysql.binlog.BinaryLogClient;
import org.dbsyncer.connector.mysql.deserializer.DeleteDeserializer;
import org.dbsyncer.connector.mysql.deserializer.UpdateDeserializer;
import org.dbsyncer.connector.mysql.deserializer.WriteDeserializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryLogRemoteClient
implements BinaryLogClient {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final SSLSocketFactory DEFAULT_REQUIRED_SSL_MODE_SOCKET_FACTORY = new DefaultSSLSocketFactory(){

        protected void initSSLContext(SSLContext sc) throws GeneralSecurityException {
            sc.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }
            }}, null);
        }
    };
    private static final SSLSocketFactory DEFAULT_VERIFY_CA_SSL_MODE_SOCKET_FACTORY = new DefaultSSLSocketFactory();
    private static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private final String hostname;
    private final int port;
    private final String schema;
    private final String username;
    private final String password;
    private SSLMode sslMode = SSLMode.DISABLED;
    private EventDeserializer eventDeserializer;
    private Map<Long, TableMapEventData> tableMapEventByTableId;
    private boolean blocking = true;
    private long serverId = 65535L;
    private volatile String binlogFilename;
    private volatile long binlogPosition = 4L;
    private volatile long connectionId;
    private volatile PacketChannel channel;
    private volatile boolean connected;
    private volatile boolean connectedError;
    private Thread worker;
    private Thread keepAlive;
    private String workerThreadName;
    private final Lock connectLock = new ReentrantLock();
    private boolean gtidEnabled = false;
    private final Object gtidSetAccessLock = new Object();
    private GtidSet gtidSet;
    private String gtid;
    private boolean tx;
    private boolean gtidSetFallbackToPurged;
    private boolean useBinlogFilenamePositionInGtidMode;
    private Boolean isMariaDB;
    private final List<EventListener> eventListeners = new CopyOnWriteArrayList<EventListener>();
    private final List<LifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<LifecycleListener>();

    public BinaryLogRemoteClient(String hostname, int port, String username, String password) throws IOException {
        this(hostname, port, null, username, password, 0L);
    }

    public BinaryLogRemoteClient(String hostname, int port, String schema, String username, String password, long serverId) throws IOException {
        this.hostname = hostname;
        this.port = port;
        this.schema = schema;
        this.username = username;
        this.password = password;
        this.serverId = this.randomPort(serverId);
    }

    @Override
    public void connect() throws Exception {
        try {
            this.connectLock.lock();
            if (this.connected) {
                throw new IllegalStateException("BinaryLogRemoteClient is already connected");
            }
            this.setConfig();
            this.openChannel();
            this.connected = true;
            this.spawnKeepAliveThread();
            this.requestBinaryLogStream();
            this.ensureEventDeserializerHasRequiredEDDs();
            this.spawnWorkerThread();
            this.lifecycleListeners.forEach(listener -> listener.onConnect(this));
        }
        finally {
            this.connectLock.unlock();
        }
    }

    @Override
    public void disconnect() throws Exception {
        if (this.connected) {
            try {
                this.connectLock.lock();
                this.closeChannel(this.channel);
                this.connected = false;
                if (null != this.worker && !this.worker.isInterrupted()) {
                    this.worker.interrupt();
                    this.worker = null;
                }
                if (null != this.keepAlive && !this.keepAlive.isInterrupted()) {
                    this.keepAlive.interrupt();
                    this.keepAlive = null;
                }
                this.lifecycleListeners.forEach(listener -> listener.onDisconnect(this));
            }
            finally {
                this.connectLock.unlock();
            }
        }
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public void registerEventListener(EventListener eventListener) {
        this.eventListeners.add(eventListener);
    }

    @Override
    public void registerLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycleListeners.add(lifecycleListener);
    }

    private String createClientId() {
        return this.hostname + ":" + this.port + "_" + this.connectionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openChannel() throws IOException {
        ChecksumType checksumType;
        try {
            Socket socket = new Socket();
            socket.connect(new InetSocketAddress(this.hostname, this.port), 3000);
            this.channel = new PacketChannel(socket);
            if (this.channel.getInputStream().peek() == -1) {
                throw new EOFException();
            }
        }
        catch (IOException e) {
            this.closeChannel(this.channel);
            throw new IOException("Failed to connect to MySQL on " + this.hostname + ":" + this.port + ". Please make sure it's running.", e);
        }
        GreetingPacket greetingPacket = this.receiveGreeting(this.channel);
        this.detectMariaDB(greetingPacket);
        this.tryUpgradeToSSL(greetingPacket);
        new Authenticator(greetingPacket, this.channel, this.schema, this.username, this.password).authenticate();
        this.channel.authenticationComplete();
        this.connectionId = greetingPacket.getThreadId();
        if ("".equals(this.binlogFilename)) {
            this.setupGtidSet();
        }
        if (this.binlogFilename == null) {
            this.fetchBinlogFilenameAndPosition();
        }
        if (this.binlogPosition < 4L) {
            this.logger.warn("Binary log position adjusted from {} to {}", (Object)this.binlogPosition, (Object)4);
            this.binlogPosition = 4L;
        }
        if ((checksumType = this.fetchBinlogChecksum()) != ChecksumType.NONE) {
            this.confirmSupportOfChecksum(this.channel, checksumType);
        }
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            String position = this.gtidSet != null ? this.gtidSet.toString() : this.binlogFilename + "/" + this.binlogPosition;
            this.logger.info("Connected to {}:{} at {} (sid:{}, cid:{})", new Object[]{this.hostname, this.port, position, this.serverId, this.connectionId});
        }
    }

    private void detectMariaDB(GreetingPacket packet) {
        String serverVersion = packet.getServerVersion();
        if (serverVersion == null) {
            return;
        }
        this.isMariaDB = serverVersion.toLowerCase().contains("mariadb");
    }

    private boolean tryUpgradeToSSL(GreetingPacket greetingPacket) throws IOException {
        if (this.sslMode != SSLMode.DISABLED) {
            boolean serverSupportsSSL;
            boolean bl = serverSupportsSSL = (greetingPacket.getServerCapabilities() & 0x800) != 0;
            if (!(serverSupportsSSL || this.sslMode != SSLMode.REQUIRED && this.sslMode != SSLMode.VERIFY_CA && this.sslMode != SSLMode.VERIFY_IDENTITY)) {
                throw new IOException("MySQL server does not support SSL");
            }
            if (serverSupportsSSL) {
                SSLRequestCommand sslRequestCommand = new SSLRequestCommand();
                int collation = greetingPacket.getServerCollation();
                sslRequestCommand.setCollation(collation);
                this.channel.write((Command)sslRequestCommand);
                SSLSocketFactory sslSocketFactory = this.sslMode == SSLMode.REQUIRED || this.sslMode == SSLMode.PREFERRED ? DEFAULT_REQUIRED_SSL_MODE_SOCKET_FACTORY : DEFAULT_VERIFY_CA_SSL_MODE_SOCKET_FACTORY;
                this.channel.upgradeToSSL(sslSocketFactory, (HostnameVerifier)(this.sslMode == SSLMode.VERIFY_IDENTITY ? new TLSHostnameVerifier() : null));
                this.logger.info("SSL enabled");
                return true;
            }
        }
        return false;
    }

    private void listenForEventPackets(PacketChannel channel) {
        ByteArrayInputStream inputStream = channel.getInputStream();
        try {
            while (inputStream.peek() != -1) {
                int packetLength = inputStream.readInteger(3);
                inputStream.skip(1L);
                int marker = inputStream.read();
                if (marker == 255) {
                    ErrorPacket errorPacket = new ErrorPacket(inputStream.read(packetLength - 1));
                    throw new ServerException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
                }
                if (marker == 254 && !this.blocking) break;
                Event event = this.eventDeserializer.nextEvent(packetLength == 0xFFFFFF ? new ByteArrayInputStream(this.readPacketSplitInChunks(inputStream, packetLength - 1)) : inputStream);
                if (event != null) {
                    this.updateGtidSet(event);
                    this.notifyEventListeners(event);
                    this.updateClientBinlogFilenameAndPosition(event);
                    continue;
                }
                throw new EOFException("event data deserialization exception");
            }
        }
        catch (Exception e) {
            this.notifyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureEventDeserializerHasRequiredEDDs() {
        this.ensureEventDataDeserializerIfPresent(EventType.ROTATE, RotateEventDataDeserializer.class);
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            if (this.gtidEnabled) {
                this.ensureEventDataDeserializerIfPresent(EventType.GTID, GtidEventDataDeserializer.class);
                this.ensureEventDataDeserializerIfPresent(EventType.QUERY, QueryEventDataDeserializer.class);
                this.ensureEventDataDeserializerIfPresent(EventType.ANNOTATE_ROWS, AnnotateRowsEventDataDeserializer.class);
                this.ensureEventDataDeserializerIfPresent(EventType.MARIADB_GTID, MariadbGtidEventDataDeserializer.class);
                this.ensureEventDataDeserializerIfPresent(EventType.MARIADB_GTID_LIST, MariadbGtidListEventDataDeserializer.class);
            }
        }
    }

    protected void checkError(byte[] packet) throws IOException {
        if (packet[0] == -1) {
            byte[] bytes = Arrays.copyOfRange(packet, 1, packet.length);
            ErrorPacket errorPacket = new ErrorPacket(bytes);
            throw new ServerException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
        }
    }

    private GreetingPacket receiveGreeting(PacketChannel channel) throws IOException {
        byte[] initialHandshakePacket = channel.read();
        if (initialHandshakePacket[0] == -1) {
            byte[] bytes = Arrays.copyOfRange(initialHandshakePacket, 1, initialHandshakePacket.length);
            ErrorPacket errorPacket = new ErrorPacket(bytes);
            throw new ServerException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
        }
        return new GreetingPacket(initialHandshakePacket);
    }

    private void requestBinaryLogStream() throws IOException {
        long serverId;
        long l = serverId = this.blocking ? this.serverId : 0L;
        if (this.isMariaDB.booleanValue()) {
            this.requestBinaryLogStreamMaria(serverId);
            return;
        }
        this.requestBinaryLogStreamMysql(serverId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestBinaryLogStreamMysql(long serverId) throws IOException {
        Object dumpBinaryLogCommand;
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            dumpBinaryLogCommand = this.gtidEnabled ? new DumpBinaryLogGtidCommand(serverId, this.useBinlogFilenamePositionInGtidMode ? this.binlogFilename : "", this.useBinlogFilenamePositionInGtidMode ? this.binlogPosition : 4L, this.gtidSet) : new DumpBinaryLogCommand(serverId, this.binlogFilename, this.binlogPosition);
        }
        this.channel.write((Command)dumpBinaryLogCommand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestBinaryLogStreamMaria(long serverId) throws IOException {
        DumpBinaryLogCommand dumpBinaryLogCommand;
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            if (this.gtidEnabled) {
                this.channel.write((Command)new QueryCommand("SET @mariadb_slave_capability=4"));
                this.checkError(this.channel.read());
                this.logger.info(this.gtidSet.toString());
                this.channel.write((Command)new QueryCommand("SET @slave_connect_state = '" + this.gtidSet.toString() + "'"));
                this.checkError(this.channel.read());
                this.channel.write((Command)new QueryCommand("SET @slave_gtid_strict_mode = 0"));
                this.checkError(this.channel.read());
                this.channel.write((Command)new QueryCommand("SET @slave_gtid_ignore_duplicates = 0"));
                this.checkError(this.channel.read());
                dumpBinaryLogCommand = new DumpBinaryLogCommand(serverId, "", 0L, false);
            } else {
                dumpBinaryLogCommand = new DumpBinaryLogCommand(serverId, this.binlogFilename, this.binlogPosition);
            }
        }
        this.channel.write((Command)dumpBinaryLogCommand);
    }

    private void ensureEventDataDeserializerIfPresent(EventType eventType, Class<? extends EventDataDeserializer<?>> eventDataDeserializerClass) {
        EventDataDeserializer eventDataDeserializer = this.eventDeserializer.getEventDataDeserializer(eventType);
        if (eventDataDeserializer.getClass() != eventDataDeserializerClass && eventDataDeserializer.getClass() != EventDeserializer.EventDataWrapper.Deserializer.class) {
            EventDataDeserializer<?> internalEventDataDeserializer;
            try {
                internalEventDataDeserializer = eventDataDeserializerClass.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.eventDeserializer.setEventDataDeserializer(eventType, (EventDataDeserializer)new EventDeserializer.EventDataWrapper.Deserializer(internalEventDataDeserializer, eventDataDeserializer));
        }
    }

    private String fetchGtidPurged() throws IOException {
        this.channel.write((Command)new QueryCommand("show global variables like 'gtid_purged'"));
        ResultSetRowPacket[] resultSet = this.readResultSet();
        if (resultSet.length != 0) {
            return resultSet[0].getValue(1).toUpperCase();
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupGtidSet() throws IOException {
        if (!this.gtidEnabled) {
            return;
        }
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            if (this.isMariaDB.booleanValue()) {
                if (this.gtidSet == null) {
                    this.gtidSet = new MariadbGtidSet("");
                } else if (!(this.gtidSet instanceof MariadbGtidSet)) {
                    throw new RuntimeException("Connected to MariaDB but given a mysql GTID set!");
                }
            } else if (this.gtidSet == null && this.gtidSetFallbackToPurged) {
                this.gtidSet = new GtidSet(this.fetchGtidPurged());
            } else if (this.gtidSet == null) {
                this.gtidSet = new GtidSet("");
            } else if (this.gtidSet instanceof MariadbGtidSet) {
                throw new RuntimeException("Connected to Mysql but given a MariaDB GTID set!");
            }
        }
    }

    private void fetchBinlogFilenameAndPosition() throws IOException {
        this.channel.write((Command)new QueryCommand("show master status"));
        ResultSetRowPacket[] resultSet = this.readResultSet();
        if (resultSet.length == 0) {
            throw new IOException("Failed to determine binlog filename/position");
        }
        ResultSetRowPacket resultSetRow = resultSet[0];
        this.binlogFilename = resultSetRow.getValue(0);
        this.binlogPosition = Long.parseLong(resultSetRow.getValue(1));
    }

    private ChecksumType fetchBinlogChecksum() throws IOException {
        this.channel.write((Command)new QueryCommand("show global variables like 'binlog_checksum'"));
        ResultSetRowPacket[] resultSet = this.readResultSet();
        if (resultSet.length == 0) {
            return ChecksumType.NONE;
        }
        return ChecksumType.valueOf((String)resultSet[0].getValue(1).toUpperCase());
    }

    private void confirmSupportOfChecksum(PacketChannel channel, ChecksumType checksumType) throws IOException {
        channel.write((Command)new QueryCommand("set @master_binlog_checksum= @@global.binlog_checksum"));
        byte[] statementResult = channel.read();
        this.checkError(statementResult);
        this.eventDeserializer.setChecksumType(checksumType);
    }

    private byte[] readPacketSplitInChunks(ByteArrayInputStream inputStream, int packetLength) throws IOException {
        int chunkLength;
        byte[] result = inputStream.read(packetLength);
        do {
            chunkLength = inputStream.readInteger(3);
            inputStream.skip(1L);
            result = Arrays.copyOf(result, result.length + chunkLength);
            inputStream.fill(result, result.length - chunkLength, chunkLength);
        } while (chunkLength == 0xFFFFFF);
        return result;
    }

    private void updateClientBinlogFilenameAndPosition(Event event) {
        EventHeaderV4 trackableEventHeader;
        long nextBinlogPosition;
        EventHeader eventHeader = event.getHeader();
        EventType eventType = eventHeader.getEventType();
        if (eventType == EventType.ROTATE) {
            RotateEventData rotateEventData = (RotateEventData)EventDeserializer.EventDataWrapper.internal((EventData)event.getData());
            this.binlogFilename = rotateEventData.getBinlogFilename();
            this.binlogPosition = rotateEventData.getBinlogPosition();
        } else if (eventType != EventType.TABLE_MAP && eventHeader instanceof EventHeaderV4 && (nextBinlogPosition = (trackableEventHeader = (EventHeaderV4)eventHeader).getNextPosition()) > 0L) {
            this.binlogPosition = nextBinlogPosition;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGtidSet(Event event) {
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            if (this.gtidSet == null) {
                return;
            }
        }
        EventHeader eventHeader = event.getHeader();
        switch (eventHeader.getEventType()) {
            case GTID: {
                GtidEventData gtidEventData = (GtidEventData)EventDeserializer.EventDataWrapper.internal((EventData)event.getData());
                this.gtid = gtidEventData.getGtid();
                break;
            }
            case XID: {
                this.commitGtid();
                this.tx = false;
                break;
            }
            case QUERY: {
                QueryEventData queryEventData = (QueryEventData)EventDeserializer.EventDataWrapper.internal((EventData)event.getData());
                String sql = queryEventData.getSql();
                if (sql == null) break;
                if ("BEGIN".equals(sql)) {
                    this.tx = true;
                    break;
                }
                if ("COMMIT".equals(sql) || "ROLLBACK".equals(sql)) {
                    this.commitGtid();
                    this.tx = false;
                    break;
                }
                if (this.tx) break;
                this.commitGtid();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitGtid() {
        if (this.gtid != null) {
            Object object = this.gtidSetAccessLock;
            synchronized (object) {
                this.gtidSet.add(this.gtid);
            }
        }
    }

    private ResultSetRowPacket[] readResultSet() throws IOException {
        byte[] bytes;
        LinkedList<ResultSetRowPacket> resultSet = new LinkedList<ResultSetRowPacket>();
        byte[] statementResult = this.channel.read();
        if (statementResult[0] == -1) {
            byte[] bytes2 = Arrays.copyOfRange(statementResult, 1, statementResult.length);
            ErrorPacket errorPacket = new ErrorPacket(bytes2);
            throw new ServerException(errorPacket.getErrorMessage(), errorPacket.getErrorCode(), errorPacket.getSqlState());
        }
        while (this.channel.read()[0] != -2) {
        }
        while ((bytes = this.channel.read())[0] != -2) {
            resultSet.add(new ResultSetRowPacket(bytes));
        }
        return resultSet.toArray(new ResultSetRowPacket[0]);
    }

    private void closeChannel(PacketChannel channel) throws IOException {
        if (channel != null && channel.isOpen()) {
            channel.close();
        }
    }

    private void setConfig() {
        if (null == this.tableMapEventByTableId) {
            this.tableMapEventByTableId = new HashMap<Long, TableMapEventData>();
        }
        IdentityHashMap<EventType, Object> eventDataDeserializers = new IdentityHashMap<EventType, Object>();
        if (null == this.eventDeserializer) {
            this.eventDeserializer = new EventDeserializer((EventHeaderDeserializer)new EventHeaderV4Deserializer(), (EventDataDeserializer)new NullEventDataDeserializer(), eventDataDeserializers, this.tableMapEventByTableId);
        }
        eventDataDeserializers.put(EventType.ROTATE, new RotateEventDataDeserializer());
        eventDataDeserializers.put(EventType.FORMAT_DESCRIPTION, new FormatDescriptionEventDataDeserializer());
        eventDataDeserializers.put(EventType.TABLE_MAP, new TableMapEventDataDeserializer());
        eventDataDeserializers.put(EventType.UPDATE_ROWS, new UpdateRowsEventDataDeserializer(this.tableMapEventByTableId));
        eventDataDeserializers.put(EventType.WRITE_ROWS, new WriteRowsEventDataDeserializer(this.tableMapEventByTableId));
        eventDataDeserializers.put(EventType.DELETE_ROWS, new DeleteRowsEventDataDeserializer(this.tableMapEventByTableId));
        eventDataDeserializers.put(EventType.EXT_WRITE_ROWS, new WriteDeserializer(this.tableMapEventByTableId).setMayContainExtraInformation(true));
        eventDataDeserializers.put(EventType.EXT_UPDATE_ROWS, new UpdateDeserializer(this.tableMapEventByTableId).setMayContainExtraInformation(true));
        eventDataDeserializers.put(EventType.EXT_DELETE_ROWS, new DeleteDeserializer(this.tableMapEventByTableId).setMayContainExtraInformation(true));
        eventDataDeserializers.put(EventType.XID, new XidEventDataDeserializer());
        eventDataDeserializers.put(EventType.INTVAR, new IntVarEventDataDeserializer());
        eventDataDeserializers.put(EventType.QUERY, new QueryEventDataDeserializer());
        eventDataDeserializers.put(EventType.ROWS_QUERY, new RowsQueryEventDataDeserializer());
        eventDataDeserializers.put(EventType.GTID, new GtidEventDataDeserializer());
        eventDataDeserializers.put(EventType.PREVIOUS_GTIDS, new PreviousGtidSetDeserializer());
        eventDataDeserializers.put(EventType.XA_PREPARE, new XAPrepareEventDataDeserializer());
    }

    private void notifyEventListeners(Event event) {
        if (event.getData() instanceof EventDeserializer.EventDataWrapper) {
            event = new Event(event.getHeader(), ((EventDeserializer.EventDataWrapper)event.getData()).getExternal());
        }
        for (EventListener eventListener : this.eventListeners) {
            try {
                eventListener.onEvent(event);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) continue;
                this.logger.warn(eventListener + " choked on " + event, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long randomPort(long serverId) throws IOException {
        if (0L == serverId) {
            ServerSocket serverSocket = null;
            try {
                serverSocket = new ServerSocket(0);
                long l = serverSocket.getLocalPort();
                return l;
            }
            finally {
                if (null != serverSocket) {
                    serverSocket.close();
                }
            }
        }
        return serverId;
    }

    private void spawnWorkerThread() {
        this.worker = new Thread(() -> this.listenForEventPackets(this.channel));
        this.worker.setDaemon(false);
        this.workerThreadName = "binlog-parser-" + this.createClientId();
        this.worker.setName(this.workerThreadName);
        this.worker.start();
    }

    private void spawnKeepAliveThread() {
        String clientId = this.createClientId();
        this.keepAlive = new Thread(() -> {
            while (this.connected) {
                try {
                    TimeUnit.SECONDS.sleep(30L);
                    this.channel.write((Command)new PingCommand());
                }
                catch (Exception e) {
                    this.notifyException(e);
                    break;
                }
            }
            while (this.connectedError) {
                try {
                    this.logger.info("Trying to restore lost connection to {}}", (Object)this.createClientId());
                    TimeUnit.MILLISECONDS.sleep(500L);
                    this.disconnect();
                    this.connect();
                    this.connectedError = false;
                    break;
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        });
        this.keepAlive.setDaemon(false);
        this.keepAlive.setName("binlog-keepalive-" + clientId);
        this.keepAlive.start();
    }

    private void notifyException(Exception e) {
        if (this.connected) {
            this.logger.error(e.getMessage(), (Throwable)e);
            this.lifecycleListeners.forEach(listener -> listener.onException(this, e));
            this.connectedError = true;
        }
    }

    @Override
    public String getBinlogFilename() {
        return this.binlogFilename;
    }

    @Override
    public void setBinlogFilename(String binlogFilename) {
        this.binlogFilename = binlogFilename;
    }

    @Override
    public long getBinlogPosition() {
        return this.binlogPosition;
    }

    @Override
    public void setBinlogPosition(long binlogPosition) {
        this.binlogPosition = binlogPosition;
    }

    @Override
    public EventDeserializer getEventDeserializer() {
        return this.eventDeserializer;
    }

    @Override
    public void setEventDeserializer(EventDeserializer eventDeserializer) {
        if (eventDeserializer == null) {
            throw new IllegalArgumentException("Event deserializer cannot be NULL");
        }
        this.eventDeserializer = eventDeserializer;
    }

    @Override
    public Map<Long, TableMapEventData> getTableMapEventByTableId() {
        return this.tableMapEventByTableId;
    }

    @Override
    public void setTableMapEventByTableId(Map<Long, TableMapEventData> tableMapEventByTableId) {
        this.tableMapEventByTableId = tableMapEventByTableId;
    }

    @Override
    public String getWorkerThreadName() {
        return this.workerThreadName;
    }

    public SSLMode getSSLMode() {
        return this.sslMode;
    }

    public void setSSLMode(SSLMode sslMode) {
        if (sslMode == null) {
            throw new IllegalArgumentException("SSL mode cannot be NULL");
        }
        this.sslMode = sslMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getGtidSet() {
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            return this.gtidSet != null ? this.gtidSet.toString() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGtidSet(String gtidStr) {
        if (gtidStr == null) {
            return;
        }
        this.gtidEnabled = true;
        if (this.binlogFilename == null) {
            this.binlogFilename = "";
        }
        Object object = this.gtidSetAccessLock;
        synchronized (object) {
            if (!gtidStr.equals("")) {
                this.gtidSet = MariadbGtidSet.isMariaGtidSet((String)gtidStr) ? new MariadbGtidSet(gtidStr) : new GtidSet(gtidStr);
            }
        }
    }

    public boolean isGtidSetFallbackToPurged() {
        return this.gtidSetFallbackToPurged;
    }

    public void setGtidSetFallbackToPurged(boolean gtidSetFallbackToPurged) {
        this.gtidSetFallbackToPurged = gtidSetFallbackToPurged;
    }

    public boolean isUseBinlogFilenamePositionInGtidMode() {
        return this.useBinlogFilenamePositionInGtidMode;
    }

    public void setUseBinlogFilenamePositionInGtidMode(boolean useBinlogFilenamePositionInGtidMode) {
        this.useBinlogFilenamePositionInGtidMode = useBinlogFilenamePositionInGtidMode;
    }

    public static interface LifecycleListener {
        public void onConnect(BinaryLogRemoteClient var1);

        public void onException(BinaryLogRemoteClient var1, Exception var2);

        public void onDisconnect(BinaryLogRemoteClient var1);
    }

    public static interface EventListener {
        public void onEvent(Event var1);
    }
}

