/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.mysql.cdc;

import com.github.shyiko.mysql.binlog.event.DeleteRowsEventData;
import com.github.shyiko.mysql.binlog.event.Event;
import com.github.shyiko.mysql.binlog.event.EventHeader;
import com.github.shyiko.mysql.binlog.event.EventHeaderV4;
import com.github.shyiko.mysql.binlog.event.EventType;
import com.github.shyiko.mysql.binlog.event.QueryEventData;
import com.github.shyiko.mysql.binlog.event.RotateEventData;
import com.github.shyiko.mysql.binlog.event.RowsQueryEventData;
import com.github.shyiko.mysql.binlog.event.TableMapEventData;
import com.github.shyiko.mysql.binlog.event.UpdateRowsEventData;
import com.github.shyiko.mysql.binlog.event.WriteRowsEventData;
import com.github.shyiko.mysql.binlog.network.ServerException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.alter.Alter;
import org.dbsyncer.common.QueueOverflowException;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.mysql.MySQLException;
import org.dbsyncer.connector.mysql.binlog.BinaryLogClient;
import org.dbsyncer.connector.mysql.binlog.BinaryLogRemoteClient;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.listener.AbstractDatabaseListener;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.event.DDLChangedEvent;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.dbsyncer.sdk.model.ChangedOffset;
import org.dbsyncer.sdk.util.DatabaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class MySQLListener
extends AbstractDatabaseListener {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String BINLOG_FILENAME = "fileName";
    private final String BINLOG_POSITION = "position";
    private final int MASTER = 0;
    private Map<Long, TableMapEventData> tables = new HashMap<Long, TableMapEventData>();
    private BinaryLogClient client;
    private List<Host> cluster;
    private String database;
    private final Lock connectLock = new ReentrantLock();

    public void start() {
        try {
            this.connectLock.lock();
            if (this.client != null && this.client.isConnected()) {
                this.logger.error("MySQLExtractor is already started");
                return;
            }
            this.run();
        }
        catch (Exception e) {
            this.logger.error("\u542f\u52a8\u5931\u8d25:{}", (Object)e.getMessage());
            throw new MySQLException(e);
        }
        finally {
            this.connectLock.unlock();
        }
    }

    public void close() {
        try {
            this.connectLock.lock();
            if (this.client != null && this.client.isConnected()) {
                this.client.disconnect();
            }
        }
        catch (Exception e) {
            this.logger.error("\u5173\u95ed\u5931\u8d25:{}", (Object)e.getMessage());
        }
        finally {
            this.connectLock.unlock();
        }
    }

    public void refreshEvent(ChangedOffset offset) {
        this.refreshSnapshot(offset.getNextFileName(), (Long)offset.getPosition());
    }

    private void run() throws Exception {
        DatabaseConfig config = ((DatabaseConnectorInstance)this.getConnectorInstance()).getConfig();
        if (StringUtil.isBlank((CharSequence)config.getUrl())) {
            throw new MySQLException("url is invalid");
        }
        this.database = DatabaseUtil.getDatabaseName((String)config.getUrl());
        this.cluster = this.readNodes(config.getUrl());
        Assert.notEmpty(this.cluster, (String)"MySQL\u8fde\u63a5\u5730\u5740\u6709\u8bef.");
        Host host = this.cluster.get(0);
        String username = config.getUsername();
        String password = config.getPassword();
        boolean containsPos = this.snapshot.containsKey("position");
        this.client = new BinaryLogRemoteClient(host.getIp(), host.getPort(), username, password);
        this.client.setBinlogFilename((String)this.snapshot.get("fileName"));
        this.client.setBinlogPosition(containsPos ? Long.parseLong((String)this.snapshot.get("position")) : 0L);
        this.client.setTableMapEventByTableId(this.tables);
        this.client.registerEventListener(new InnerEventListener());
        this.client.registerLifecycleListener(new InnerLifecycleListener());
        this.client.connect();
        if (!containsPos) {
            this.refreshSnapshot(this.client.getBinlogFilename(), this.client.getBinlogPosition());
            super.forceFlushEvent();
        }
    }

    private List<Host> readNodes(String url) {
        Matcher matcher = Pattern.compile("(//)(?!(/)).+?(/)").matcher(url);
        if (matcher.find()) {
            url = matcher.group(0);
        }
        url = StringUtil.replace((String)url, (String)"/", (String)"");
        ArrayList<Host> cluster = new ArrayList<Host>();
        String[] arr = StringUtil.split((String)url, (String)",");
        int size = arr.length;
        for (int i = 0; i < size; ++i) {
            String[] host = StringUtil.split((String)arr[i], (String)":");
            if (2 != host.length) continue;
            cluster.add(new Host(host[0], Integer.parseInt(host[1])));
        }
        return cluster;
    }

    private void refresh(EventHeader header) {
        EventHeaderV4 eventHeaderV4 = (EventHeaderV4)header;
        this.refresh(null, eventHeaderV4.getNextPosition());
    }

    private void refresh(String binlogFilename, long nextPosition) {
        if (StringUtil.isNotBlank((CharSequence)binlogFilename)) {
            this.client.setBinlogFilename(binlogFilename);
        }
        if (0L < nextPosition) {
            this.client.setBinlogPosition(nextPosition);
        }
    }

    private void refreshSnapshot(String binlogFilename, long nextPosition) {
        this.snapshot.put("fileName", binlogFilename);
        this.snapshot.put("position", String.valueOf(nextPosition));
    }

    private void trySendEvent(ChangedEvent event) {
        try {
            long now = Instant.now().toEpochMilli();
            boolean isReTry = false;
            while (this.client.isConnected()) {
                try {
                    this.sendChangedEvent(event);
                    break;
                }
                catch (QueueOverflowException e) {
                    isReTry = true;
                    try {
                        TimeUnit.MILLISECONDS.sleep(1L);
                    }
                    catch (InterruptedException ex) {
                        this.logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            if (isReTry) {
                this.logger.info("\u91cd\u8bd5\u8017\u65f6\uff1a{}ms", (Object)(Instant.now().toEpochMilli() - now));
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    final class InnerEventListener
    implements BinaryLogRemoteClient.EventListener {
        private boolean notUniqueCodeEvent = true;

        InnerEventListener() {
        }

        @Override
        public void onEvent(Event event) {
            EventHeader header = event.getHeader();
            if (header.getEventType() == EventType.XID) {
                MySQLListener.this.refresh(header);
                return;
            }
            if (header.getEventType() == EventType.ROWS_QUERY) {
                RowsQueryEventData data = (RowsQueryEventData)event.getData();
                this.notUniqueCodeEvent = this.isNotUniqueCodeEvent(data.getQuery());
                return;
            }
            if (this.notUniqueCodeEvent && EventType.isUpdate((EventType)header.getEventType())) {
                MySQLListener.this.refresh(header);
                UpdateRowsEventData data = (UpdateRowsEventData)event.getData();
                if (this.isFilterTable(data.getTableId())) {
                    data.getRows().forEach(m -> {
                        List after = Stream.of((Object[])m.getValue()).collect(Collectors.toList());
                        MySQLListener.this.trySendEvent((ChangedEvent)new RowChangedEvent(this.getTableName(data.getTableId()), "UPDATE", after, MySQLListener.this.client.getBinlogFilename(), (Object)MySQLListener.this.client.getBinlogPosition()));
                    });
                }
                return;
            }
            if (this.notUniqueCodeEvent && EventType.isWrite((EventType)header.getEventType())) {
                MySQLListener.this.refresh(header);
                WriteRowsEventData data = (WriteRowsEventData)event.getData();
                if (this.isFilterTable(data.getTableId())) {
                    data.getRows().forEach(m -> {
                        List after = Stream.of(m).collect(Collectors.toList());
                        MySQLListener.this.trySendEvent((ChangedEvent)new RowChangedEvent(this.getTableName(data.getTableId()), "INSERT", after, MySQLListener.this.client.getBinlogFilename(), (Object)MySQLListener.this.client.getBinlogPosition()));
                    });
                }
                return;
            }
            if (this.notUniqueCodeEvent && EventType.isDelete((EventType)header.getEventType())) {
                MySQLListener.this.refresh(header);
                DeleteRowsEventData data = (DeleteRowsEventData)event.getData();
                if (this.isFilterTable(data.getTableId())) {
                    data.getRows().forEach(m -> {
                        List before = Stream.of(m).collect(Collectors.toList());
                        MySQLListener.this.trySendEvent((ChangedEvent)new RowChangedEvent(this.getTableName(data.getTableId()), "DELETE", before, MySQLListener.this.client.getBinlogFilename(), (Object)MySQLListener.this.client.getBinlogPosition()));
                    });
                }
                return;
            }
            if (EventType.QUERY == header.getEventType()) {
                MySQLListener.this.refresh(header);
                this.parseDDL((QueryEventData)event.getData());
                return;
            }
            if (header.getEventType() == EventType.ROTATE) {
                RotateEventData data = (RotateEventData)event.getData();
                MySQLListener.this.refresh(data.getBinlogFilename(), data.getBinlogPosition());
            }
        }

        private void parseDDL(QueryEventData data) {
            if (this.isNotUniqueCodeEvent(data.getSql()) && StringUtil.startsWith((CharSequence)data.getSql(), (CharSequence)"ALTER")) {
                try {
                    Alter alter = (Alter)CCJSqlParserUtil.parse((String)data.getSql());
                    String tableName = StringUtil.replace((String)alter.getTable().getName(), (String)"`", (String)"");
                    if (this.isFilterTable(data.getDatabase(), tableName)) {
                        MySQLListener.this.logger.info("sql:{}", (Object)data.getSql());
                        MySQLListener.this.trySendEvent((ChangedEvent)new DDLChangedEvent(data.getDatabase(), tableName, "ALTER", data.getSql(), MySQLListener.this.client.getBinlogFilename(), (Object)MySQLListener.this.client.getBinlogPosition()));
                    }
                }
                catch (JSQLParserException e) {
                    MySQLListener.this.logger.error("\u4e0d\u652f\u6301ddl sql\uff0c\u652f\u6301\u6807\u51c6\u7684sql\u683c\u5f0f\uff0c\u8bf7\u67e5\u770b\u6587\u6863https://gitee.com/ghi/dbsyncer/wikis/%E5%BF%AB%E9%80%9F%E4%BA%86%E8%A7%A3/%E8%A1%A8%E7%BB%93%E6%9E%84%E5%90%8C%E6%AD%A5");
                }
            }
        }

        private String getTableName(long tableId) {
            return ((TableMapEventData)MySQLListener.this.tables.get(tableId)).getTable();
        }

        private boolean isFilterTable(long tableId) {
            TableMapEventData tableMap = (TableMapEventData)MySQLListener.this.tables.get(tableId);
            return this.isFilterTable(tableMap.getDatabase(), tableMap.getTable());
        }

        private boolean isFilterTable(String dbName, String tableName) {
            return StringUtil.equalsIgnoreCase((CharSequence)MySQLListener.this.database, (CharSequence)dbName) && MySQLListener.this.filterTable.contains(tableName);
        }

        private boolean isNotUniqueCodeEvent(String sql) {
            return !StringUtil.startsWith((CharSequence)sql, (CharSequence)"/*dbs*/");
        }
    }

    final class InnerLifecycleListener
    implements BinaryLogRemoteClient.LifecycleListener {
        InnerLifecycleListener() {
        }

        @Override
        public void onConnect(BinaryLogRemoteClient client) {
            MySQLListener.this.refresh(client.getBinlogFilename(), client.getBinlogPosition());
        }

        @Override
        public void onException(BinaryLogRemoteClient client, Exception e) {
            ServerException serverException;
            if (!client.isConnected()) {
                return;
            }
            if (e instanceof ServerException && (serverException = (ServerException)e).getErrorCode() == 1236) {
                String log = String.format("\u7ebf\u7a0b[%s]\u6267\u884c\u5f02\u5e38\u3002\u7531\u4e8eMySQL\u914d\u7f6e\u4e86\u8fc7\u671fbinlog\u6587\u4ef6\u81ea\u52a8\u5220\u9664\u673a\u5236\uff0c\u5df2\u65e0\u6cd5\u627e\u5230\u539fbinlog\u6587\u4ef6%s\u3002\u5efa\u8bae\u5148\u4fdd\u5b58\u9a71\u52a8\uff08\u52a0\u8f7d\u6700\u65b0\u7684binlog\u6587\u4ef6\uff09\uff0c\u518d\u542f\u52a8\u9a71\u52a8\u3002", client.getWorkerThreadName(), client.getBinlogFilename());
                MySQLListener.this.errorEvent(new MySQLException(log));
                MySQLListener.this.close();
                return;
            }
            MySQLListener.this.errorEvent(new MySQLException(e.getMessage()));
        }

        @Override
        public void onDisconnect(BinaryLogRemoteClient client) {
        }
    }

    final class Host {
        private String ip;
        private int port;

        public Host(String ip, int port) {
            this.ip = ip;
            this.port = port;
        }

        public String getIp() {
            return this.ip;
        }

        public int getPort() {
            return this.port;
        }
    }
}

