/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.mysql.storage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.dbsyncer.common.model.Paging;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.common.util.UnderlineToCamelUtils;
import org.dbsyncer.connector.mysql.MySQLConnector;
import org.dbsyncer.sdk.NullExecutorException;
import org.dbsyncer.sdk.config.DatabaseConfig;
import org.dbsyncer.sdk.config.SqlBuilderConfig;
import org.dbsyncer.sdk.connector.database.Database;
import org.dbsyncer.sdk.connector.database.DatabaseConnectorInstance;
import org.dbsyncer.sdk.connector.database.DatabaseTemplate;
import org.dbsyncer.sdk.enums.FilterEnum;
import org.dbsyncer.sdk.enums.SqlBuilderEnum;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.filter.AbstractFilter;
import org.dbsyncer.sdk.filter.BooleanFilter;
import org.dbsyncer.sdk.filter.Query;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.storage.AbstractStorageService;
import org.dbsyncer.sdk.util.DatabaseUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.util.Assert;

public class MySQLStorageService
extends AbstractStorageService {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String PREFIX_TABLE = "dbsyncer_";
    private final String SHOW_TABLE = "show tables where Tables_in_%s = '%s'";
    private final String DROP_TABLE = "DROP TABLE %s";
    private final String TRUNCATE_TABLE = "TRUNCATE TABLE %s";
    private final MySQLConnector connector = new MySQLConnector();
    private Map<String, Executor> tables = new ConcurrentHashMap<String, Executor>();
    private DatabaseConnectorInstance connectorInstance;
    private String database;

    public void init(Properties properties) {
        DatabaseConfig config = new DatabaseConfig();
        config.setConnectorType(properties.getProperty("dbsyncer.storage.type"));
        config.setUrl(properties.getProperty("dbsyncer.storage.mysql.url", "jdbc:mysql://127.0.0.1:3306/dbsyncer?rewriteBatchedStatements=true&seUnicode=true&characterEncoding=UTF8&serverTimezone=Asia/Shanghai&useSSL=false&verifyServerCertificate=false&autoReconnect=true"));
        config.setUsername(properties.getProperty("dbsyncer.storage.mysql.username", "admin"));
        config.setPassword(properties.getProperty("dbsyncer.storage.mysql.password", "admin"));
        config.setDriverClassName(properties.getProperty("dbsyncer.storage.mysql.driver-class-name"));
        this.logger.info("url:{}", (Object)config.getUrl());
        this.database = DatabaseUtil.getDatabaseName((String)config.getUrl());
        this.connectorInstance = new DatabaseConnectorInstance(config);
        this.initTable();
    }

    protected String getSeparator() {
        return "_";
    }

    protected Paging select(String sharding, Query query) {
        Paging paging = new Paging(query.getPageNum(), query.getPageSize());
        Executor executor = this.getExecutor(query.getType(), sharding);
        if (executor == null) {
            return paging;
        }
        ArrayList<Object> queryCountArgs = new ArrayList<Object>();
        String queryCountSql = this.buildQueryCountSql(query, executor, queryCountArgs);
        Long total = (Long)this.connectorInstance.execute(databaseTemplate -> (Long)databaseTemplate.queryForObject(queryCountSql, queryCountArgs.toArray(), Long.class));
        paging.setTotal(total.longValue());
        if (query.isQueryTotal()) {
            return paging;
        }
        ArrayList<AbstractFilter> highLightKeys = new ArrayList<AbstractFilter>();
        ArrayList<Object> queryArgs = new ArrayList<Object>();
        String querySql = this.buildQuerySql(query, executor, queryArgs, highLightKeys);
        List data = (List)this.connectorInstance.execute(databaseTemplate -> databaseTemplate.queryForList(querySql, queryArgs.toArray()));
        this.replaceHighLight(highLightKeys, data);
        paging.setData((Collection)data);
        return paging;
    }

    /*
     * Exception decompiling
     */
    protected void delete(String sharding, Query query) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void deleteAll(String sharding) {
        AtomicBoolean systemTable = new AtomicBoolean();
        this.tables.computeIfPresent(sharding, (k, executor) -> {
            systemTable.set(((Executor)executor).systemTable);
            String sql = this.getExecutorSql((Executor)executor, (String)k);
            this.executeSql(sql);
            return executor;
        });
        if (!systemTable.get()) {
            this.tables.remove(sharding);
        }
    }

    protected void batchInsert(StorageEnum type, String sharding, List<Map> list) {
        this.batchExecute(type, sharding, list, new ExecuteMapper(){

            @Override
            public String getSql(Executor executor) {
                return executor.getInsert();
            }

            @Override
            public Object[] getArgs(Executor executor, Map params) {
                return MySQLStorageService.this.getInsertArgs(executor, params);
            }
        });
    }

    protected void batchUpdate(StorageEnum type, String sharding, List<Map> list) {
        this.batchExecute(type, sharding, list, new ExecuteMapper(){

            @Override
            public String getSql(Executor executor) {
                return executor.getUpdate();
            }

            @Override
            public Object[] getArgs(Executor executor, Map params) {
                return MySQLStorageService.this.getUpdateArgs(executor, params);
            }
        });
    }

    /*
     * Exception decompiling
     */
    protected void batchDelete(StorageEnum type, String sharding, List<String> ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void destroy() {
        this.connectorInstance.close();
    }

    private void batchExecute(StorageEnum type, String sharding, List<Map> list, ExecuteMapper mapper) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Executor executor = this.getExecutor(type, sharding);
        if (executor == null) {
            return;
        }
        String sql = mapper.getSql(executor);
        List args = list.stream().map(row -> mapper.getArgs(executor, (Map)row)).collect(Collectors.toList());
        this.connectorInstance.execute(databaseTemplate -> databaseTemplate.batchUpdate(sql, args));
    }

    private Executor getExecutor(StorageEnum type, String sharding) {
        return this.tables.computeIfAbsent(sharding, table -> {
            Executor executor = this.tables.get(type.getType());
            if (executor == null) {
                throw new NullExecutorException("\u672a\u77e5\u7684\u5b58\u50a8\u7c7b\u578b");
            }
            Executor newExecutor = new Executor(executor.getType(), executor.getFields(), executor.isSystemTable(), executor.isOrderByUpdateTime());
            return this.createTableIfNotExist((String)table, newExecutor);
        });
    }

    private String getExecutorSql(Executor executor, String sharding) {
        return executor.isSystemTable() ? String.format("TRUNCATE TABLE %s", "dbsyncer_".concat(sharding)) : String.format("DROP TABLE %s", "dbsyncer_".concat(sharding));
    }

    private Object[] getInsertArgs(Executor executor, Map params) {
        return executor.getFields().stream().map(f -> params.get(f.getLabelName())).collect(Collectors.toList()).toArray();
    }

    private Object[] getUpdateArgs(Executor executor, Map params) {
        ArrayList args = new ArrayList();
        Object pk = null;
        for (Field f : executor.getFields()) {
            if (f.isPk()) {
                pk = params.get(f.getLabelName());
                continue;
            }
            args.add(params.get(f.getLabelName()));
        }
        Assert.notNull(pk, (String)"The primaryKey is null.");
        args.add(pk);
        return args.toArray();
    }

    private String buildQuerySql(Query query, Executor executor, List<Object> args, List<AbstractFilter> highLightKeys) {
        StringBuilder sql = new StringBuilder(executor.getQuery());
        this.buildQuerySqlWithParams(query, args, sql, highLightKeys);
        sql.append(" order by ");
        if (executor.isOrderByUpdateTime()) {
            sql.append(UnderlineToCamelUtils.camelToUnderline((String)"updateTime")).append(",");
        }
        sql.append(UnderlineToCamelUtils.camelToUnderline((String)"createTime"));
        sql.append(" ").append(query.getSort().getCode());
        sql.append(" LIMIT ?,?");
        args.add((query.getPageNum() - 1) * query.getPageSize());
        args.add(query.getPageSize());
        return sql.toString();
    }

    private String buildQueryCountSql(Query query, Executor executor, List<Object> args) {
        StringBuilder queryCount = new StringBuilder();
        queryCount.append("SELECT COUNT(1) FROM (");
        StringBuilder sql = new StringBuilder("SELECT 1 AS `_ROW` FROM `").append(executor.getTable()).append("`");
        this.buildQuerySqlWithParams(query, args, sql, null);
        queryCount.append((CharSequence)sql);
        queryCount.append(" GROUP BY `ID`) DBSYNCER_T");
        return queryCount.toString();
    }

    private void buildQuerySqlWithParams(Query query, List<Object> args, StringBuilder sql, List<AbstractFilter> highLightKeys) {
        BooleanFilter baseQuery = query.getBooleanFilter();
        List clauses = baseQuery.getClauses();
        List filters = baseQuery.getFilters();
        if (CollectionUtils.isEmpty((Collection)clauses) && CollectionUtils.isEmpty((Collection)filters)) {
            return;
        }
        sql.append(" WHERE ");
        if (!CollectionUtils.isEmpty((Collection)filters)) {
            this.buildQuerySqlWithFilters(filters, args, sql, highLightKeys);
            return;
        }
        this.buildQuerySqlWithBooleanFilters(clauses, args, sql, highLightKeys);
    }

    private void buildQuerySqlWithFilters(List<AbstractFilter> filters, List<Object> args, StringBuilder sql, List<AbstractFilter> highLightKeys) {
        int size = filters.size();
        String quotation = this.connector.buildSqlWithQuotation();
        for (int i = 0; i < size; ++i) {
            AbstractFilter p = filters.get(i);
            if (i > 0) {
                sql.append(" ").append(p.getOperation().toUpperCase()).append(" ");
            }
            FilterEnum filterEnum = FilterEnum.getFilterEnum((String)p.getFilter());
            String name = UnderlineToCamelUtils.camelToUnderline((String)p.getName());
            switch (filterEnum) {
                case EQUAL: {
                    sql.append(quotation).append(name).append(quotation).append(" = ?");
                    args.add(p.getValue());
                    break;
                }
                case LIKE: {
                    sql.append(quotation).append(name).append(quotation).append(" LIKE ?");
                    args.add(new StringBuilder("%").append(p.getValue()).append("%"));
                    break;
                }
                case LT: {
                    sql.append(quotation).append(name).append(quotation).append(" < ?");
                    args.add(p.getValue());
                }
            }
            if (null == highLightKeys || !p.isEnableHighLightSearch()) continue;
            highLightKeys.add(p);
        }
    }

    private void buildQuerySqlWithBooleanFilters(List<BooleanFilter> clauses, List<Object> args, StringBuilder sql, List<AbstractFilter> highLightKeys) {
        int size = clauses.size();
        for (int i = 0; i < size; ++i) {
            BooleanFilter booleanFilter = clauses.get(i);
            List filters = booleanFilter.getFilters();
            if (CollectionUtils.isEmpty((Collection)filters)) continue;
            if (i > 0) {
                sql.append(" ").append(booleanFilter.getOperationEnum().name().toUpperCase()).append(" ");
            }
            if (size > 0) {
                sql.append("(");
            }
            this.buildQuerySqlWithFilters(filters, args, sql, highLightKeys);
            if (size <= 0) continue;
            sql.append(")");
        }
    }

    private void initTable() {
        FieldBuilder builder = new FieldBuilder();
        builder.build("id", "name", "type", "createTime", "updateTime", "json");
        List<Field> configFields = builder.getFields();
        builder.build("id", "type", "createTime", "json");
        List<Field> logFields = builder.getFields();
        builder.build("id", "success", "tableGroupId", "targetTableName", "event", "error", "createTime", "data");
        List<Field> dataFields = builder.getFields();
        this.tables.computeIfAbsent(StorageEnum.CONFIG.getType(), k -> new Executor((String)k, configFields, true, true));
        this.tables.computeIfAbsent(StorageEnum.LOG.getType(), k -> new Executor((String)k, logFields, true, false));
        this.tables.computeIfAbsent(StorageEnum.DATA.getType(), k -> new Executor((String)k, dataFields, false, false));
        this.tables.forEach((tableName, e) -> {
            if (e.isSystemTable()) {
                this.createTableIfNotExist((String)tableName, (Executor)e);
            }
        });
        try {
            TimeUnit.SECONDS.sleep(1L);
        }
        catch (InterruptedException e2) {
            this.logger.error(e2.getMessage(), (Throwable)e2);
        }
    }

    private Executor createTableIfNotExist(String table, Executor executor) {
        table = "dbsyncer_".concat(table);
        String sql = String.format("show tables where Tables_in_%s = '%s'", this.database, table);
        try {
            this.connectorInstance.execute(databaseTemplate -> databaseTemplate.queryForMap(sql));
        }
        catch (EmptyResultDataAccessException e) {
            String ddl = this.readSql(executor.getType(), executor.isSystemTable(), table);
            this.executeSql(ddl);
        }
        List<Field> fields = executor.getFields();
        ArrayList<String> primaryKeys = new ArrayList<String>();
        primaryKeys.add("id");
        SqlBuilderConfig config = new SqlBuilderConfig((Database)this.connector, "", table, primaryKeys, fields, "");
        String query = SqlBuilderEnum.QUERY.getSqlBuilder().buildQuerySql(config);
        String insert = SqlBuilderEnum.INSERT.getSqlBuilder().buildSql(config);
        String update = SqlBuilderEnum.UPDATE.getSqlBuilder().buildSql(config);
        String delete = SqlBuilderEnum.DELETE.getSqlBuilder().buildSql(config);
        executor.setTable(table).setQuery(query).setInsert(insert).setUpdate(update).setDelete(delete);
        return executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readSql(String type, boolean systemTable, String table) {
        String filePath = this.getSqlFilePath(type);
        StringBuilder res = new StringBuilder();
        InputStream in = null;
        InputStreamReader isr = null;
        BufferedReader bf = null;
        try {
            String newLine;
            in = ((Object)((Object)this)).getClass().getResourceAsStream(filePath);
            isr = new InputStreamReader(in, "UTF-8");
            bf = new BufferedReader(isr);
            while ((newLine = bf.readLine()) != null) {
                res.append(newLine);
            }
        }
        catch (IOException e) {
            try {
                this.logger.error("failed read file:{}", (Object)filePath);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bf);
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly((InputStream)in);
                throw throwable;
            }
            IOUtils.closeQuietly(bf);
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)in);
        }
        IOUtils.closeQuietly((Reader)bf);
        IOUtils.closeQuietly((Reader)isr);
        IOUtils.closeQuietly((InputStream)in);
        if (!systemTable) {
            String template = "dbsyncer_".concat(type);
            return StringUtil.replace((String)res.toString(), (String)template, (String)table);
        }
        return res.toString();
    }

    private String getSqlFilePath(String type) {
        return "/" + "dbsyncer_" + this.connector.getConnectorType().toLowerCase() + "_" + type + ".sql";
    }

    private void executeSql(String ddl) {
        this.connectorInstance.execute(databaseTemplate -> {
            databaseTemplate.execute(ddl);
            this.logger.info(ddl);
            return true;
        });
    }

    private void replaceHighLight(List<AbstractFilter> highLightKeys, List<Map<String, Object>> list) {
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(highLightKeys)) {
            list.forEach(row -> highLightKeys.forEach(paramFilter -> {
                String text = String.valueOf(row.get(paramFilter.getName()));
                String replacement = "<span style='color:red'>" + paramFilter.getValue() + "</span>";
                row.put(paramFilter.getName(), StringUtil.replace((String)text, (String)paramFilter.getValue(), (String)replacement));
            }));
        }
    }

    private static /* synthetic */ Object lambda$batchDelete$6(String sql, List args, DatabaseTemplate databaseTemplate) throws Exception {
        return databaseTemplate.batchUpdate(sql, args);
    }

    private static /* synthetic */ Object lambda$delete$3(StringBuilder sql, List args, DatabaseTemplate databaseTemplate) throws Exception {
        return databaseTemplate.batchUpdate(sql.toString(), args);
    }

    static interface ExecuteMapper {
        public String getSql(Executor var1);

        public Object[] getArgs(Executor var1, Map var2);
    }

    final class Executor {
        private String table;
        private String query;
        private String insert;
        private String update;
        private String delete;
        private String type;
        private List<Field> fields;
        private boolean systemTable;
        private boolean orderByUpdateTime;

        public Executor(String type, List<Field> fields, boolean systemTable, boolean orderByUpdateTime) {
            this.type = type;
            this.fields = fields;
            this.systemTable = systemTable;
            this.orderByUpdateTime = orderByUpdateTime;
        }

        public Executor setTable(String table) {
            this.table = table;
            return this;
        }

        public String getTable() {
            return this.table;
        }

        public String getQuery() {
            return this.query;
        }

        public Executor setQuery(String query) {
            this.query = query;
            return this;
        }

        public String getInsert() {
            return this.insert;
        }

        public Executor setInsert(String insert) {
            this.insert = insert;
            return this;
        }

        public String getUpdate() {
            return this.update;
        }

        public Executor setUpdate(String update) {
            this.update = update;
            return this;
        }

        public String getDelete() {
            return this.delete;
        }

        public Executor setDelete(String delete) {
            this.delete = delete;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public List<Field> getFields() {
            return this.fields;
        }

        public boolean isSystemTable() {
            return this.systemTable;
        }

        public boolean isOrderByUpdateTime() {
            return this.orderByUpdateTime;
        }
    }

    final class FieldBuilder {
        Map<String, Field> fieldMap = Stream.of(new Field("id", "VARCHAR", 12, true), new Field("name", "VARCHAR", 12), new Field("type", "VARCHAR", 12), new Field("createTime", "BIGINT", -5), new Field("updateTime", "BIGINT", -5), new Field("json", "LONGVARCHAR", -1), new Field("success", "INTEGER", 4), new Field("tableGroupId", "VARCHAR", 12), new Field("targetTableName", "VARCHAR", 12), new Field("event", "VARCHAR", 12), new Field("error", "LONGVARCHAR", -1), new Field("status", "INTEGER", 4), new Field("data", "VARBINARY", 2004)).map(field -> {
            field.setLabelName(field.getName());
            String labelName = UnderlineToCamelUtils.camelToUnderline((String)field.getName());
            field.setName(labelName);
            return field;
        }).collect(Collectors.toMap(Field::getLabelName, field -> field));
        List<Field> fields;

        public List<Field> getFields() {
            return this.fields;
        }

        public void build(String ... fieldNames) {
            this.fields = new ArrayList<Field>(fieldNames.length);
            ((Stream)Stream.of(fieldNames).parallel()).forEach(k -> {
                if (this.fieldMap.containsKey(k)) {
                    Field field = this.fieldMap.get(k);
                    this.fields.add(field);
                }
            });
        }
    }
}

