/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.common.column;

public final class Lexer {
    private final char[] array;
    private final int length;
    private int pos = 0;
    private String token;

    public Lexer(String input) {
        this.array = input.toCharArray();
        this.length = this.array.length;
    }

    public String token() {
        return this.token;
    }

    public String nextToken(char comma) {
        if (this.pos < this.length) {
            StringBuilder out = new StringBuilder(16);
            while (this.pos < this.length && this.array[this.pos] != comma) {
                out.append(this.array[this.pos]);
                ++this.pos;
            }
            ++this.pos;
            this.token = out.toString();
            return this.token;
        }
        this.token = null;
        return null;
    }

    public String nextTokenToQuote() {
        if (this.pos < this.length) {
            int commaCount = 1;
            StringBuilder out = new StringBuilder(16);
            while (this.pos != this.length - 1 && (this.array[this.pos + 1] != ' ' || commaCount % 2 != 1) || this.array[this.pos] != '\'') {
                if (this.array[this.pos] == '\'') {
                    ++commaCount;
                }
                out.append(this.array[this.pos]);
                ++this.pos;
            }
            ++this.pos;
            this.token = out.toString();
            return this.token;
        }
        this.token = null;
        return null;
    }

    public void skip(int skip) {
        this.pos += skip;
    }

    public char current() {
        return this.array[this.pos];
    }

    public boolean hasNext() {
        return this.pos < this.length;
    }
}

