/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.common.scheduled.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import javax.annotation.Resource;
import org.dbsyncer.common.CommonException;
import org.dbsyncer.common.scheduled.ScheduledTaskJob;
import org.dbsyncer.common.scheduled.ScheduledTaskService;
import org.dbsyncer.common.util.UUIDUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.stereotype.Component;

@Component
public class ScheduledTaskServiceImpl
implements ScheduledTaskService,
DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ThreadPoolTaskScheduler taskScheduler;
    private Map<String, ScheduledFuture> map = new ConcurrentHashMap<String, ScheduledFuture>();

    @Override
    public void start(String key, String cron, ScheduledTaskJob job) {
        this.logger.info("[{}], Started task [{}]", (Object)cron, (Object)job.getClass().getName());
        this.apply(key, () -> this.taskScheduler.schedule((Runnable)job, trigger -> new CronTrigger(cron).nextExecutionTime(trigger)));
    }

    @Override
    public void start(String key, long period, ScheduledTaskJob job) {
        this.logger.info("[period={}], Started task [{}]", (Object)period, (Object)job.getClass().getName());
        this.apply(key, () -> this.taskScheduler.scheduleAtFixedRate((Runnable)job, period));
    }

    @Override
    public void start(String cron, ScheduledTaskJob job) {
        this.start(UUIDUtil.getUUID(), cron, job);
    }

    @Override
    public void start(long period, ScheduledTaskJob job) {
        this.start(UUIDUtil.getUUID(), period, job);
    }

    @Override
    public void stop(String key) {
        ScheduledFuture job = this.map.get(key);
        if (null != job) {
            job.cancel(true);
            this.map.remove(key);
            this.logger.info("Stopped task [{}]", (Object)key);
        }
    }

    private void apply(String key, ScheduledFutureMapper scheduledFutureMapper) {
        ScheduledFuture scheduledFuture = this.map.get(key);
        if (null != scheduledFuture && !scheduledFuture.isCancelled()) {
            String msg = String.format(">>>>>> \u4efb\u52a1\u5df2\u542f\u52a8 %s  >>>>>>", key);
            this.logger.error(msg);
            throw new CommonException(msg);
        }
        this.map.putIfAbsent(key, scheduledFutureMapper.apply());
    }

    public void destroy() {
        this.map.keySet().forEach(this::stop);
    }

    private static interface ScheduledFutureMapper {
        public ScheduledFuture apply();
    }
}

