/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.common.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Ticker;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.interceptor.KeyGenerator;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="dbsyncer.web")
public class CacheConfig {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Map<String, CacheProperties> cache;

    @Bean
    public KeyGenerator cacheKeyGenerator() {
        return (target, method, params) -> {
            String className = method.getDeclaringClass().getSimpleName();
            String methodName = method.getName();
            String paramHash = String.valueOf(Arrays.toString(params).hashCode());
            String cacheKey = new StringJoiner("_").add(className).add(methodName).add(paramHash).toString();
            this.logger.debug("generate cache key : {}", (Object)cacheKey);
            return cacheKey;
        };
    }

    @Bean
    public Ticker ticker() {
        return Ticker.systemTicker();
    }

    @Bean
    public CacheManager cacheManager(Ticker ticker) {
        SimpleCacheManager manager = new SimpleCacheManager();
        if (this.cache != null) {
            List caches = this.cache.entrySet().stream().map(entry -> this.buildCache((String)entry.getKey(), (CacheProperties)entry.getValue(), ticker)).collect(Collectors.toList());
            manager.setCaches(caches);
        }
        return manager;
    }

    private CaffeineCache buildCache(String key, CacheProperties config, Ticker ticker) {
        this.logger.info("Cache key {} specified timeout of {} seconds, max of {}", new Object[]{key, config.getTimeout(), config.getMax()});
        Caffeine caffeineBuilder = Caffeine.newBuilder().expireAfterWrite((long)config.getTimeout().intValue(), TimeUnit.SECONDS).maximumSize((long)config.getMax().intValue()).ticker(ticker);
        return new CaffeineCache(key, caffeineBuilder.build());
    }

    public void setCache(Map<String, CacheProperties> cache) {
        this.cache = cache;
    }

    static class CacheProperties {
        private Integer timeout;
        private Integer max = 200;

        CacheProperties() {
        }

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public Integer getMax() {
            return this.max;
        }

        public void setMax(Integer max) {
            this.max = max;
        }
    }
}

