/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.common.util;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalField;
import org.dbsyncer.common.CommonException;
import org.dbsyncer.common.column.Lexer;

public abstract class DateFormatUtil {
    public static final DateTimeFormatter CHINESE_STANDARD_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat GMT_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSz");
    public static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss");
    private static final ZoneId zoneId = ZoneId.systemDefault();
    private static final DateTimeFormatter TIME_TZ_FORMAT = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:mm", "").toFormatter();
    private static final DateTimeFormatter NON_ISO_LOCAL_DATE = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR_OF_ERA, 4, 10, SignStyle.NEVER).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).toFormatter();
    private static final DateTimeFormatter TS_FORMAT = new DateTimeFormatterBuilder().append(NON_ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral(" ").appendText((TemporalField)ChronoField.ERA, TextStyle.SHORT).optionalEnd().toFormatter();
    private static final DateTimeFormatter TS_TZ_FORMAT = new DateTimeFormatterBuilder().append(NON_ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:mm", "").optionalStart().appendLiteral(" ").appendText((TemporalField)ChronoField.ERA, TextStyle.SHORT).optionalEnd().toFormatter();
    private static final DateTimeFormatter TS_TZ_WITH_SECONDS_FORMAT = new DateTimeFormatterBuilder().append(NON_ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:MM:SS", "").optionalStart().appendLiteral(" ").appendText((TemporalField)ChronoField.ERA, TextStyle.SHORT).optionalEnd().toFormatter();
    private static final DateTimeFormatter TS_TZ_FORMAT_ORACLE = new DateTimeFormatterBuilder().append(NON_ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).appendLiteral(' ').appendOffset("+HH:mm", "").toFormatter();

    public static String getCurrentTime() {
        return LocalDateTime.now().format(TIME_FORMATTER);
    }

    public static String dateToString(Date date) {
        return date.toLocalDate().format(DATE_FORMATTER);
    }

    public static String dateToString(java.util.Date date) {
        return date.toInstant().atZone(zoneId).toLocalDateTime().format(CHINESE_STANDARD_TIME_FORMATTER);
    }

    public static Date stringToDate(String s) {
        return Date.valueOf(LocalDate.parse(s, DATE_FORMATTER));
    }

    public static String timestampToString(Timestamp timestamp) {
        return timestamp.toLocalDateTime().format(CHINESE_STANDARD_TIME_FORMATTER);
    }

    public static LocalTime stringToLocalTime(String s) {
        return LocalTime.parse(s, CHINESE_STANDARD_TIME_FORMATTER);
    }

    public static Timestamp stringToTimestamp(String s) {
        try {
            if (s.length() < 19) {
                return Timestamp.valueOf(LocalDateTime.from(CHINESE_STANDARD_TIME_FORMATTER.parse(DateFormatUtil.format(s))));
            }
            if (s.length() == 19) {
                return Timestamp.valueOf(LocalDateTime.from(CHINESE_STANDARD_TIME_FORMATTER.parse(s)));
            }
            if (s.length() == 21) {
                s = s.substring(0, s.lastIndexOf("."));
                return Timestamp.valueOf(LocalDateTime.from(CHINESE_STANDARD_TIME_FORMATTER.parse(s)));
            }
            if (s.length() == 28) {
                return DateFormatUtil.stringToTimestamp(s, GMT_FORMATTER);
            }
            if (s.length() == 29) {
                s = s.replaceAll(":[^:]*$", "00");
                return DateFormatUtil.stringToTimestamp(s, GMT_FORMATTER);
            }
            throw new CommonException(String.format("Can not parse val[%s] to Timestamp", s));
        }
        catch (ParseException e) {
            throw new CommonException(e);
        }
    }

    public static Timestamp stringToTimestamp(String s, DateFormat formatter) throws ParseException {
        return new Timestamp(formatter.parse(s).getTime());
    }

    public static Timestamp timeWithoutTimeZoneToTimestamp(String s) {
        return Timestamp.valueOf(LocalDateTime.from(TS_FORMAT.parse(s)).atZone(ZoneOffset.UTC).toLocalDateTime());
    }

    public static OffsetTime timeWithTimeZone(String s) {
        return OffsetTime.parse(s, TIME_TZ_FORMAT).withOffsetSameInstant(ZoneOffset.UTC);
    }

    public static OffsetDateTime timestampWithTimeZoneToOffsetDateTime(String s) {
        TemporalAccessor parsedTimestamp;
        try {
            parsedTimestamp = TS_TZ_FORMAT.parse(s);
        }
        catch (DateTimeParseException e) {
            parsedTimestamp = TS_TZ_WITH_SECONDS_FORMAT.parse(s);
        }
        return OffsetDateTime.from(parsedTimestamp).withOffsetSameInstant(ZoneOffset.UTC);
    }

    public static OffsetDateTime timestampWithTimeZoneToOffsetDateTimeOracle(String s) {
        return OffsetDateTime.from(TS_TZ_FORMAT_ORACLE.parse(s)).withOffsetSameInstant(ZoneOffset.UTC);
    }

    private static String format(String s) {
        StringBuilder buf = new StringBuilder();
        Lexer lexer = new Lexer(s);
        char comma = '-';
        DateFormatUtil.nextToken(lexer, buf, comma);
        DateFormatUtil.nextToken(lexer, buf, comma);
        comma = ' ';
        DateFormatUtil.nextToken(lexer, buf, comma);
        comma = ':';
        DateFormatUtil.nextToken(lexer, buf, comma);
        DateFormatUtil.nextToken(lexer, buf, comma);
        DateFormatUtil.nextToken(lexer, buf, comma, false);
        return buf.toString();
    }

    private static void nextToken(Lexer lexer, StringBuilder buf, char comma) {
        DateFormatUtil.nextToken(lexer, buf, comma, true);
    }

    private static void nextToken(Lexer lexer, StringBuilder buf, char comma, boolean appendComma) {
        buf.append(DateFormatUtil.fillZero(lexer.nextToken(comma)));
        if (appendComma) {
            buf.append(comma);
        }
    }

    private static String fillZero(String s) {
        if (s.length() < 2) {
            return String.format("%02d", Integer.parseInt(s));
        }
        return s;
    }
}

