/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.elasticsearch.cdc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.sdk.enums.QuartzFilterEnum;
import org.dbsyncer.sdk.listener.AbstractQuartzListener;
import org.dbsyncer.sdk.listener.QuartzFilter;
import org.dbsyncer.sdk.model.Filter;
import org.dbsyncer.sdk.model.Point;
import org.elasticsearch.ElasticsearchException;

public final class ESQuartzListener
extends AbstractQuartzListener {
    protected Point checkLastPoint(Map<String, String> command, int index) {
        String filterJson = command.get("QUERY_FILTER");
        if (StringUtil.isBlank((CharSequence)filterJson)) {
            return new Point(command, new ArrayList());
        }
        List filters = JsonUtil.jsonToArray((String)filterJson, Filter.class);
        if (CollectionUtils.isEmpty((Collection)filters)) {
            return new Point(command, new ArrayList());
        }
        Point point = new Point();
        HashSet<String> set = new HashSet<String>();
        for (Filter f : filters) {
            if (set.contains(f.getValue())) {
                throw new ElasticsearchException(String.format("\u7cfb\u7edf\u53c2\u6570%s\u5b58\u5728\u591a\u4e2a.", f.getValue()), new Object[0]);
            }
            QuartzFilterEnum filterEnum = QuartzFilterEnum.getQuartzFilterEnum((String)f.getValue());
            if (null == filterEnum) continue;
            set.add(f.getValue());
            QuartzFilter quartzFilter = filterEnum.getQuartzFilter();
            String key = index + filterEnum.getType();
            if (quartzFilter.begin()) {
                if (!this.snapshot.containsKey(key)) {
                    f.setValue(quartzFilter.toString(quartzFilter.getObject()));
                    this.snapshot.put(key, f.getValue());
                    continue;
                }
                f.setValue((String)this.snapshot.get(key));
                point.setBeginKey(key);
                point.setBeginValue(quartzFilter.toString(quartzFilter.getObject()));
                continue;
            }
            f.setValue(quartzFilter.toString(quartzFilter.getObject()));
            point.setBeginValue(f.getValue());
        }
        point.setCommand("QUERY", command.get("QUERY"));
        point.setCommand("QUERY_FILTER", JsonUtil.objToJson((Object)filters));
        return point;
    }
}

