/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.consumer;

import java.util.List;
import java.util.Map;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.flush.impl.BufferActuatorRouter;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.Watcher;
import org.dbsyncer.sdk.listener.event.DDLChangedEvent;
import org.dbsyncer.sdk.listener.event.SqlChangedEvent;

public abstract class AbstractConsumer<E extends ChangedEvent>
implements Watcher {
    private BufferActuatorRouter bufferActuatorRouter;
    private ProfileComponent profileComponent;
    private LogService logService;
    private String metaId;
    protected Mapping mapping;
    protected List<TableGroup> tableGroups;

    public AbstractConsumer init(BufferActuatorRouter bufferActuatorRouter, ProfileComponent profileComponent, LogService logService, String metaId, Mapping mapping, List<TableGroup> tableGroups) {
        this.bufferActuatorRouter = bufferActuatorRouter;
        this.profileComponent = profileComponent;
        this.logService = logService;
        this.metaId = metaId;
        this.mapping = mapping;
        this.tableGroups = tableGroups;
        this.postProcessBeforeInitialization();
        return this;
    }

    public abstract void postProcessBeforeInitialization();

    public abstract void onChange(E var1);

    public void onDDLChanged(DDLChangedEvent event) {
    }

    public void onSqlChanged(SqlChangedEvent event) {
    }

    public void changeEvent(ChangedEvent event) {
        event.getChangedOffset().setMetaId(this.metaId);
        switch (event.getType()) {
            case ROW: 
            case SCAN: {
                this.onChange(event);
                break;
            }
            case SQL: {
                this.onSqlChanged((SqlChangedEvent)event);
                break;
            }
            case DDL: {
                this.onDDLChanged((DDLChangedEvent)event);
            }
        }
    }

    public void flushEvent(Map<String, String> snapshot) {
        Meta meta = this.profileComponent.getMeta(this.metaId);
        if (meta != null) {
            meta.setSnapshot(snapshot);
            this.profileComponent.editConfigModel(meta);
        }
    }

    public void errorEvent(Exception e) {
        this.logService.log(LogType.TableGroupLog.INCREMENT_FAILED, e.getMessage());
    }

    public long getMetaUpdateTime() {
        Meta meta = this.profileComponent.getMeta(this.metaId);
        return meta != null ? meta.getUpdateTime() : 0L;
    }

    protected void bind(String tableGroupId) {
        this.bufferActuatorRouter.bind(this.metaId, tableGroupId);
    }

    protected void execute(String tableGroupId, ChangedEvent event) {
        this.bufferActuatorRouter.execute(this.metaId, tableGroupId, event);
    }
}

