/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.consumer.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.parser.consumer.AbstractConsumer;
import org.dbsyncer.parser.model.FieldPicker;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.parser.util.PickerUtil;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.dbsyncer.sdk.listener.event.CommonChangedEvent;
import org.dbsyncer.sdk.listener.event.DDLChangedEvent;
import org.dbsyncer.sdk.listener.event.RowChangedEvent;
import org.dbsyncer.sdk.listener.event.SqlChangedEvent;
import org.dbsyncer.sdk.model.Table;

public final class LogConsumer
extends AbstractConsumer<RowChangedEvent> {
    private Map<String, List<FieldPicker>> tablePicker = new LinkedHashMap<String, List<FieldPicker>>();
    private boolean ddlChanged;

    @Override
    public void postProcessBeforeInitialization() {
        this.addTablePicker(true);
    }

    @Override
    public void onChange(RowChangedEvent event) {
        if (this.ddlChanged) {
            this.addTablePicker(false);
            this.ddlChanged = false;
        }
        this.process((CommonChangedEvent)event, picker -> {
            Map<String, Object> changedRow = picker.getColumns(event.getDataList());
            if (picker.filter(changedRow)) {
                event.setChangedRow(changedRow);
                this.execute(picker.getTableGroup().getId(), (ChangedEvent)event);
            }
        });
    }

    @Override
    public void onDDLChanged(DDLChangedEvent event) {
        this.ddlChanged = true;
        this.process((CommonChangedEvent)event, picker -> this.execute(picker.getTableGroup().getId(), (ChangedEvent)event));
    }

    @Override
    public void onSqlChanged(SqlChangedEvent event) {
        this.process((CommonChangedEvent)event, picker -> this.execute(picker.getTableGroup().getId(), (ChangedEvent)event));
    }

    private void process(CommonChangedEvent event, Consumer<FieldPicker> consumer) {
        List<FieldPicker> pickers = this.tablePicker.get(event.getSourceTableName());
        if (!CollectionUtils.isEmpty(pickers)) {
            event.getChangedOffset().setRefreshOffset(true);
            pickers.forEach(picker -> consumer.accept((FieldPicker)picker));
        }
    }

    private void addTablePicker(boolean bindBufferActuatorRouter) {
        this.tablePicker.clear();
        this.tableGroups.forEach(t -> {
            Table table = t.getSourceTable();
            String tableName = table.getName();
            this.tablePicker.putIfAbsent(tableName, new ArrayList());
            TableGroup group = PickerUtil.mergeTableGroupConfig(this.mapping, t);
            this.tablePicker.get(tableName).add(new FieldPicker(group, group.getFilter(), table.getColumn(), group.getFieldMapping()));
            if (bindBufferActuatorRouter) {
                this.bind(group.getId());
            }
        });
    }
}

