/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.ddl.alter;

import java.util.List;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.ddl.AlterStrategy;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.sdk.config.DDLConfig;
import org.dbsyncer.sdk.enums.DDLOperationEnum;

public class ChangeStrategy
implements AlterStrategy {
    @Override
    public void parse(AlterExpression expression, DDLConfig ddlConfig, List<FieldMapping> originalFieldMappings) {
        String oldColumnName = StringUtil.replace((String)expression.getColumnOldName(), (String)"`", (String)"");
        oldColumnName = StringUtil.replace((String)oldColumnName, (String)"\"", (String)"");
        ddlConfig.setSourceColumnName(oldColumnName);
        String finalOldColumnName = oldColumnName;
        FieldMapping fieldMapping = originalFieldMappings.stream().filter(x -> StringUtil.equals((CharSequence)x.getSource().getName(), (CharSequence)finalOldColumnName)).findFirst().orElse(null);
        if (fieldMapping != null) {
            expression.setColumnOldName(fieldMapping.getTarget().getName());
            for (AlterExpression.ColumnDataType columnDataType : expression.getColDataTypeList()) {
                ddlConfig.setChangedColumnName(columnDataType.getColumnName());
            }
        }
        ddlConfig.setDdlOperationEnum(DDLOperationEnum.ALTER_CHANGE);
    }
}

