/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.enums;

import org.dbsyncer.parser.command.CommandExecutor;
import org.dbsyncer.parser.command.Persistence;
import org.dbsyncer.parser.command.Preload;
import org.dbsyncer.parser.enums.GroupStrategyEnum;

public enum CommandEnum {
    OPR_ADD("add", Persistence::addConfig),
    OPR_EDIT("edit", Persistence::editConfig),
    PRELOAD_SYSTEM("system", Preload::parseSystemConfig, true),
    PRELOAD_USER("user", Preload::parseUserConfig, true),
    PRELOAD_CONNECTOR("connector", Preload::parseConnector, true),
    PRELOAD_MAPPING("mapping", Preload::parseMapping, true),
    PRELOAD_TABLE_GROUP("tableGroup", Preload::parseTableGroup, true, GroupStrategyEnum.TABLE),
    PRELOAD_META("meta", Preload::parseMeta, true),
    PRELOAD_PROJECT_GROUP("projectGroup", Preload::parseProjectGroup, true);

    private String modelType;
    private CommandExecutor commandExecutor;
    private boolean preload;
    private GroupStrategyEnum groupStrategyEnum;

    private CommandEnum(String modelType, CommandExecutor commandExecutor) {
        this(modelType, commandExecutor, false);
    }

    private CommandEnum(String modelType, CommandExecutor commandExecutor, boolean preload) {
        this(modelType, commandExecutor, preload, GroupStrategyEnum.DEFAULT);
    }

    private CommandEnum(String modelType, CommandExecutor commandExecutor, boolean preload, GroupStrategyEnum groupStrategyEnum) {
        this.modelType = modelType;
        this.commandExecutor = commandExecutor;
        this.preload = preload;
        this.groupStrategyEnum = groupStrategyEnum;
    }

    public String getModelType() {
        return this.modelType;
    }

    public boolean isPreload() {
        return this.preload;
    }

    public CommandExecutor getCommandExecutor() {
        return this.commandExecutor;
    }

    public GroupStrategyEnum getGroupStrategyEnum() {
        return this.groupStrategyEnum;
    }
}

