/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.enums;

import org.dbsyncer.parser.ParserException;

public enum MetaEnum {
    READY(0, "\u672a\u8fd0\u884c"),
    RUNNING(1, "\u8fd0\u884c\u4e2d"),
    STOPPING(2, "\u505c\u6b62\u4e2d");

    private int code;
    private String message;

    private MetaEnum(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public static MetaEnum getMetaEnum(int code) throws ParserException {
        for (MetaEnum e : MetaEnum.values()) {
            if (code != e.getCode()) continue;
            return e;
        }
        throw new ParserException(String.format("Meta code \"%s\" does not exist.", code));
    }

    public static boolean isRunning(int state) {
        return RUNNING.getCode() == state || STOPPING.getCode() == state;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

