/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.flush;

import java.lang.reflect.ParameterizedType;
import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Resource;
import org.dbsyncer.common.config.BufferActuatorConfig;
import org.dbsyncer.common.scheduled.ScheduledTaskJob;
import org.dbsyncer.common.scheduled.ScheduledTaskService;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.enums.MetaEnum;
import org.dbsyncer.parser.flush.BufferActuator;
import org.dbsyncer.parser.flush.BufferRequest;
import org.dbsyncer.parser.flush.BufferResponse;
import org.dbsyncer.parser.model.Meta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public abstract class AbstractBufferActuator<Request extends BufferRequest, Response extends BufferResponse>
implements BufferActuator,
ScheduledTaskJob {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<Response> responseClazz;
    private Lock taskLock;
    private BufferActuatorConfig config;
    private BlockingQueue<Request> queue;
    @Resource
    private ScheduledTaskService scheduledTaskService;
    @Resource
    private ProfileComponent profileComponent;

    public AbstractBufferActuator() {
        Class<?> aClass = this.getClass();
        for (int level = 5; level > 0; --level) {
            if (aClass.getSuperclass() == AbstractBufferActuator.class) {
                this.responseClazz = (Class)((ParameterizedType)aClass.getGenericSuperclass()).getActualTypeArguments()[1];
                break;
            }
            aClass = aClass.getSuperclass();
        }
        Assert.notNull(this.responseClazz, (String)String.format("%s\u7684\u7236\u7c7b%s\u6cdb\u578b\u53c2\u6570Response\u4e3a\u7a7a.", this.getClass().getName(), AbstractBufferActuator.class.getName()));
    }

    protected void buildConfig() {
        Assert.notNull((Object)this.config, (String)"\u8bf7\u5148\u914d\u7f6e\u7f13\u5b58\u6267\u884c\u5668\uff0csetConfig(BufferActuatorConfig config)");
        this.buildQueueConfig();
        this.scheduledTaskService.start((long)this.config.getBufferPeriodMillisecond(), (ScheduledTaskJob)this);
    }

    protected void buildQueueConfig() {
        this.taskLock = new ReentrantLock();
        this.queue = new LinkedBlockingQueue<Request>(this.config.getBufferQueueCapacity());
        this.logger.info("{} initialized with queue capacity: {}", (Object)this.getClass().getSimpleName(), (Object)this.config.getBufferQueueCapacity());
    }

    protected abstract String getPartitionKey(Request var1);

    protected abstract void partition(Request var1, Response var2);

    protected boolean isRunning(BufferRequest request) {
        Meta meta = this.profileComponent.getMeta(request.getMetaId());
        return meta != null && MetaEnum.isRunning(meta.getState());
    }

    protected boolean skipPartition(Request nextRequest, Response response) {
        return false;
    }

    protected abstract void pull(Response var1);

    protected abstract void offerFailed(BlockingQueue<Request> var1, Request var2);

    @Override
    public void offer(BufferRequest request) {
        if (this.queue.offer(request)) {
            return;
        }
        if (this.isRunning(request)) {
            this.offerFailed(this.queue, request);
        }
    }

    public void run() {
        boolean locked = false;
        try {
            locked = this.taskLock.tryLock();
            if (locked) {
                this.submit();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (locked) {
                this.taskLock.unlock();
            }
        }
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public int getQueueCapacity() {
        return this.config.getBufferQueueCapacity();
    }

    private void submit() throws IllegalAccessException, InstantiationException {
        if (this.queue.isEmpty()) {
            return;
        }
        AtomicLong batchCounter = new AtomicLong();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        while (!this.queue.isEmpty() && batchCounter.get() < (long)this.config.getBufferPullCount()) {
            BufferRequest poll = (BufferRequest)this.queue.poll();
            String key2 = this.getPartitionKey(poll);
            if (!map.containsKey(key2)) {
                map.putIfAbsent(key2, this.responseClazz.newInstance());
            }
            BufferResponse response2 = (BufferResponse)map.get(key2);
            this.partition(poll, response2);
            batchCounter.incrementAndGet();
            BufferRequest next = (BufferRequest)this.queue.peek();
            if (null == next || !this.skipPartition(next, response2)) continue;
            break;
        }
        map.forEach((key, response) -> {
            long now = Instant.now().toEpochMilli();
            try {
                this.pull(response);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            this.logger.info("[{}{}]{}, {}ms", new Object[]{key, response.getSuffixName(), response.getTaskSize(), Instant.now().toEpochMilli() - now});
        });
        map.clear();
        map = null;
        batchCounter = null;
    }

    public void setConfig(BufferActuatorConfig config) {
        this.config = config;
    }
}

