/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.CacheService;
import org.dbsyncer.parser.ParserException;
import org.dbsyncer.parser.command.impl.PersistenceCommand;
import org.dbsyncer.parser.enums.CommandEnum;
import org.dbsyncer.parser.enums.GroupStrategyEnum;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.OperationConfig;
import org.dbsyncer.parser.model.QueryConfig;
import org.dbsyncer.parser.strategy.GroupStrategy;
import org.dbsyncer.parser.util.ConfigModelUtil;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public final class OperationTemplate {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private StorageService storageService;
    @Resource
    private CacheService cacheService;

    public <T> List<T> queryAll(Class<T> valueType) {
        try {
            ConfigModel configModel = (ConfigModel)valueType.newInstance();
            return this.queryAll(new QueryConfig(configModel));
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public <T> List<T> queryAll(QueryConfig<T> query) {
        List<String> index;
        ConfigModel model = query.getConfigModel();
        String groupId = this.getGroupId(model, query.getGroupStrategyEnum());
        Group group = this.cacheService.get(groupId, Group.class);
        if (null != group && !CollectionUtils.isEmpty(index = group.getIndex())) {
            ArrayList list = new ArrayList();
            Class<?> clazz = model.getClass();
            index.forEach(e -> {
                Object v = this.cacheService.get((String)e);
                if (null != v) {
                    list.add(this.beanCopy(clazz, v));
                }
            });
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public int queryCount(QueryConfig query) {
        ConfigModel model = query.getConfigModel();
        String groupId = this.getGroupId(model, query.getGroupStrategyEnum());
        Group group = this.cacheService.get(groupId, Group.class);
        return null != group ? group.getIndex().size() : 0;
    }

    public <T> T queryObject(Class<T> clazz, String id) {
        if (StringUtil.isBlank((CharSequence)id)) {
            return null;
        }
        T o = this.cacheService.get(id, clazz);
        return this.beanCopy(clazz, o);
    }

    public String execute(OperationConfig config) {
        ConfigModel model = config.getModel();
        Assert.notNull((Object)model, (String)"ConfigModel can not be null.");
        Map<String, Object> params = ConfigModelUtil.convertModelToMap(model);
        this.logger.debug("params:{}", params);
        CommandEnum cmd = config.getCommandEnum();
        Assert.notNull((Object)((Object)cmd), (String)"CommandEnum can not be null.");
        cmd.getCommandExecutor().execute(new PersistenceCommand(this.storageService, params));
        this.cache(model, config.getGroupStrategyEnum());
        return model.getId();
    }

    public void cache(ConfigModel model, GroupStrategyEnum strategy) {
        Assert.notNull((Object)model, (String)"ConfigModel can not be null.");
        String id = model.getId();
        this.cacheService.put(id, model);
        String groupId = this.getGroupId(model, strategy);
        this.cacheService.putIfAbsent(groupId, new Group());
        Group group = this.cacheService.get(groupId, Group.class);
        group.addIfAbsent(id);
        this.logger.debug("Put the model [{}] for {} group into cache.", (Object)id, (Object)groupId);
    }

    public void remove(OperationConfig config) {
        String id = config.getId();
        Assert.hasText((String)id, (String)"ID can not be empty.");
        ConfigModel model = this.cacheService.get(id, ConfigModel.class);
        String groupId = this.getGroupId(model, config.getGroupStrategyEnum());
        Group group = this.cacheService.get(groupId, Group.class);
        if (null != group) {
            group.remove(id);
            if (0 >= group.size()) {
                this.cacheService.remove(groupId);
            }
        }
        this.cacheService.remove(id);
        this.storageService.remove(StorageEnum.CONFIG, id);
    }

    public String getGroupId(ConfigModel model, GroupStrategyEnum strategy) {
        Assert.notNull((Object)model, (String)"ConfigModel can not be null.");
        Assert.notNull((Object)((Object)strategy), (String)"GroupStrategyEnum can not be null.");
        GroupStrategy groupStrategy = strategy.getGroupStrategy();
        Assert.notNull((Object)groupStrategy, (String)"GroupStrategy can not be null.");
        String groupId = groupStrategy.getGroupId(model);
        Assert.hasText((String)groupId, (String)"GroupId can not be empty.");
        return groupId;
    }

    private <T> T beanCopy(Class<T> clazz, Object o) {
        if (null == o || null == clazz) {
            return null;
        }
        try {
            T t = clazz.newInstance();
            BeanUtils.copyProperties((Object)o, t);
            return t;
        }
        catch (InstantiationException e) {
            throw new ParserException(e);
        }
        catch (IllegalAccessException e) {
            throw new ParserException(e);
        }
    }

    public class Group {
        private List<String> index = new LinkedList<String>();

        public synchronized void addIfAbsent(String e) {
            if (!this.index.contains(e)) {
                this.index.add(e);
            }
        }

        public synchronized void remove(String e) {
            this.index.remove(e);
        }

        public int size() {
            return this.index.size();
        }

        public List<String> getIndex() {
            return Collections.unmodifiableList(this.index);
        }

        public void setIndex(List<String> index) {
            this.index = index;
        }
    }
}

