/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.impl;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.base.ConnectorFactory;
import org.dbsyncer.parser.ParserComponent;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.event.FullRefreshEvent;
import org.dbsyncer.parser.model.BatchWriter;
import org.dbsyncer.parser.model.Connector;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Picker;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.parser.model.Task;
import org.dbsyncer.parser.strategy.FlushStrategy;
import org.dbsyncer.parser.util.ConvertUtil;
import org.dbsyncer.parser.util.PickerUtil;
import org.dbsyncer.plugin.PluginFactory;
import org.dbsyncer.plugin.impl.FullPluginContext;
import org.dbsyncer.sdk.config.CommandConfig;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.config.WriterBatchConfig;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.model.ConnectorConfig;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.model.Table;
import org.dbsyncer.sdk.plugin.PluginContext;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ParserComponentImpl
implements ParserComponent {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ConnectorFactory connectorFactory;
    @Resource
    private PluginFactory pluginFactory;
    @Resource
    private FlushStrategy flushStrategy;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public MetaInfo getMetaInfo(String connectorId, String tableName) {
        Connector connector = this.profileComponent.getConnector(connectorId);
        ConnectorInstance connectorInstance = this.connectorFactory.connect(connector.getConfig());
        MetaInfo metaInfo = this.connectorFactory.getMetaInfo(connectorInstance, tableName);
        if (!CollectionUtils.isEmpty(connector.getTable())) {
            for (Table t : connector.getTable()) {
                if (!t.getName().equals(tableName)) continue;
                metaInfo.setTableType(t.getType());
                metaInfo.setSql(t.getSql());
                break;
            }
        }
        return metaInfo;
    }

    @Override
    public Map<String, String> getCommand(Mapping mapping, TableGroup tableGroup) {
        ConnectorConfig sConnConfig = this.getConnectorConfig(mapping.getSourceConnectorId());
        ConnectorConfig tConnConfig = this.getConnectorConfig(mapping.getTargetConnectorId());
        Table sourceTable = tableGroup.getSourceTable();
        Table targetTable = tableGroup.getTargetTable();
        Table sTable = new Table(sourceTable.getName(), sourceTable.getType(), new ArrayList(), sourceTable.getSql());
        Table tTable = new Table(targetTable.getName(), targetTable.getType(), new ArrayList(), sourceTable.getSql());
        List<FieldMapping> fieldMapping = tableGroup.getFieldMapping();
        if (!CollectionUtils.isEmpty(fieldMapping)) {
            fieldMapping.forEach(m -> {
                if (null != m.getSource()) {
                    sTable.getColumn().add(m.getSource());
                }
                if (null != m.getTarget()) {
                    tTable.getColumn().add(m.getTarget());
                }
            });
        }
        CommandConfig sourceConfig = new CommandConfig(sConnConfig.getConnectorType(), sTable, sConnConfig, tableGroup.getFilter());
        CommandConfig targetConfig = new CommandConfig(tConnConfig.getConnectorType(), tTable, tConnConfig, null);
        return this.connectorFactory.getCommand(sourceConfig, targetConfig);
    }

    @Override
    public long getCount(String connectorId, Map<String, String> command) {
        ConnectorInstance connectorInstance = this.connectorFactory.connect(this.getConnectorConfig(connectorId));
        return this.connectorFactory.getCount(connectorInstance, command);
    }

    @Override
    public void execute(Task task, Mapping mapping, TableGroup tableGroup, Executor executor) {
        block3: {
            List source;
            String metaId = task.getId();
            String sourceConnectorId = mapping.getSourceConnectorId();
            String targetConnectorId = mapping.getTargetConnectorId();
            ConnectorConfig sConfig = this.getConnectorConfig(sourceConnectorId);
            Assert.notNull((Object)sConfig, (String)"\u6570\u636e\u6e90\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a.");
            ConnectorConfig tConfig = this.getConnectorConfig(targetConnectorId);
            Assert.notNull((Object)tConfig, (String)"\u76ee\u6807\u6e90\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a.");
            TableGroup group = PickerUtil.mergeTableGroupConfig(mapping, tableGroup);
            Map<String, String> command = group.getCommand();
            Assert.notEmpty(command, (String)"\u6267\u884c\u547d\u4ee4\u4e0d\u80fd\u4e3a\u7a7a.");
            List<FieldMapping> fieldMapping = group.getFieldMapping();
            Table sourceTable = group.getSourceTable();
            String sTableName = sourceTable.getName();
            String tTableName = group.getTargetTable().getName();
            Assert.notEmpty(fieldMapping, (String)String.format("\u6570\u636e\u6e90\u8868[%s]\u540c\u6b65\u5230\u76ee\u6807\u6e90\u8868[%s], \u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a.", sTableName, tTableName));
            Picker picker = new Picker(fieldMapping);
            List primaryKeys = PrimaryKeyUtil.findTablePrimaryKeys((Table)sourceTable);
            boolean supportedCursor = StringUtil.isNotBlank((CharSequence)command.get("QUERY_CURSOR"));
            int pageSize = mapping.getReadNum();
            int batchSize = mapping.getBatchNum();
            ConnectorInstance sConnectorInstance = this.connectorFactory.connect(sConfig);
            ConnectorInstance tConnectorInstance = this.connectorFactory.connect(tConfig);
            String event = "INSERT";
            FullPluginContext context = new FullPluginContext(sConnectorInstance, tConnectorInstance, sTableName, tTableName, "INSERT");
            do {
                if (!task.isRunning()) {
                    this.logger.warn("\u4efb\u52a1\u88ab\u4e2d\u6b62:{}", (Object)metaId);
                    break block3;
                }
                ReaderConfig readerConfig = new ReaderConfig(sourceTable, command, new ArrayList(), supportedCursor, task.getCursors(), task.getPageIndex(), pageSize);
                Result reader = this.connectorFactory.reader(sConnectorInstance, readerConfig);
                source = reader.getSuccessData();
                if (CollectionUtils.isEmpty((Collection)source)) {
                    this.logger.info("\u5b8c\u6210\u5168\u91cf\u540c\u6b65\u4efb\u52a1:{}, [{}] >> [{}]", new Object[]{metaId, sTableName, tTableName});
                    break block3;
                }
                List<Map> target = picker.pickTargetData(source);
                ConvertUtil.convert(group.getConvert(), target);
                context.setSourceList(source);
                context.setTargetList(target);
                this.pluginFactory.convert(group.getPlugin(), (PluginContext)context);
                BatchWriter batchWriter = new BatchWriter(tConnectorInstance, command, tTableName, "INSERT", picker.getTargetFields(), target, batchSize);
                Result result = this.writeBatch((PluginContext)context, batchWriter, executor);
                task.setPageIndex(task.getPageIndex() + 1);
                task.setCursors(PrimaryKeyUtil.getLastCursors((List)source, (List)primaryKeys));
                result.setTableGroupId(tableGroup.getId());
                result.setTargetTableGroupName(tTableName);
                this.flush(task, result);
                this.pluginFactory.postProcessAfter(group.getPlugin(), (PluginContext)context);
            } while (source.size() >= pageSize);
            this.logger.info("\u5b8c\u6210\u5168\u91cf:{}, [{}] >> [{}]", new Object[]{metaId, sTableName, tTableName});
        }
    }

    @Override
    public Result writeBatch(PluginContext pluginContext, BatchWriter batchWriter, Executor executor) {
        Result result = new Result();
        if (pluginContext.isTerminated()) {
            result.getSuccessData().addAll(batchWriter.getDataList());
            return result;
        }
        List<Map> dataList = batchWriter.getDataList();
        int batchSize = batchWriter.getBatchSize();
        String tableName = batchWriter.getTableName();
        String event = batchWriter.getEvent();
        Map<String, String> command = batchWriter.getCommand();
        List<Field> fields = batchWriter.getFields();
        int total = dataList.size();
        if (total <= batchSize) {
            return this.connectorFactory.writer(batchWriter.getConnectorInstance(), new WriterBatchConfig(tableName, event, command, fields, dataList));
        }
        int taskSize = total % batchSize == 0 ? total / batchSize : total / batchSize + 1;
        CountDownLatch latch = new CountDownLatch(taskSize);
        int fromIndex = 0;
        int toIndex = batchSize;
        for (int i = 0; i < taskSize; ++i) {
            List<Map> data;
            if (toIndex > total) {
                toIndex = fromIndex + total % batchSize;
                data = dataList.subList(fromIndex, toIndex);
            } else {
                data = dataList.subList(fromIndex, toIndex);
                fromIndex += batchSize;
                toIndex += batchSize;
            }
            executor.execute(() -> {
                try {
                    Result w = this.connectorFactory.writer(batchWriter.getConnectorInstance(), new WriterBatchConfig(tableName, event, command, fields, data));
                    result.addSuccessData(w.getSuccessData());
                    result.addFailData(w.getFailData());
                    result.getError().append(w.getError());
                }
                catch (Exception e) {
                    this.logger.error(e.getMessage());
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.logger.error(e.getMessage());
        }
        return result;
    }

    private void flush(Task task, Result result) {
        this.flushStrategy.flushFullData(task.getId(), result, "INSERT");
        task.setEndTime(Instant.now().toEpochMilli());
        this.applicationContext.publishEvent((ApplicationEvent)new FullRefreshEvent(this.applicationContext, task));
    }

    private ConnectorConfig getConnectorConfig(String connectorId) {
        return this.profileComponent.getConnector(connectorId).getConfig();
    }
}

