/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.model;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.DateFormatUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.enums.FilterEnum;
import org.dbsyncer.sdk.enums.OperationEnum;
import org.dbsyncer.sdk.filter.CompareFilter;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.Filter;
import org.springframework.util.Assert;

public class FieldPicker {
    private TableGroup tableGroup;
    private List<Node> index;
    private int indexSize;
    private boolean enabledFilter;
    private List<Filter> add;
    private List<Filter> or;

    public FieldPicker(TableGroup tableGroup) {
        this.tableGroup = tableGroup;
    }

    public FieldPicker(TableGroup tableGroup, List<Filter> filter, List<Field> column, List<FieldMapping> fieldMapping) {
        this.tableGroup = tableGroup;
        this.init(filter, column, fieldMapping);
    }

    public Map<String, Object> getColumns(List<Object> list) {
        if (!CollectionUtils.isEmpty(list)) {
            HashMap<String, Object> data = new HashMap<String, Object>(this.indexSize);
            int size = list.size() - 1;
            this.index.forEach(node -> {
                if (node.i <= size) {
                    data.put(node.name, list.get(node.i));
                }
            });
            return data;
        }
        return Collections.EMPTY_MAP;
    }

    public boolean filter(Map<String, Object> row) {
        if (!this.enabledFilter) {
            return true;
        }
        Object value = null;
        for (Filter f : this.or) {
            value = row.get(f.getName());
            if (null == value || !this.compareValueWithFilter(f, value)) continue;
            return true;
        }
        boolean pass = false;
        for (Filter f : this.add) {
            value = row.get(f.getName());
            if (null == value) continue;
            if (!this.compareValueWithFilter(f, value)) {
                return false;
            }
            pass = true;
        }
        return pass;
    }

    private boolean compareValueWithFilter(Filter filter, Object comparedValue) {
        CompareFilter compareFilter = FilterEnum.getCompareFilter((String)filter.getFilter());
        if (null == filter) {
            return false;
        }
        if (comparedValue instanceof Timestamp) {
            Timestamp comparedTimestamp = (Timestamp)comparedValue;
            Timestamp filterTimestamp = DateFormatUtil.stringToTimestamp((String)filter.getValue());
            return compareFilter.compare(String.valueOf(comparedTimestamp.getTime()), String.valueOf(filterTimestamp.getTime()));
        }
        if (comparedValue instanceof Date) {
            Date comparedDate = (Date)comparedValue;
            Date filterDate = DateFormatUtil.stringToDate((String)filter.getValue());
            return compareFilter.compare(String.valueOf(comparedDate.getTime()), String.valueOf(filterDate.getTime()));
        }
        return compareFilter.compare(String.valueOf(comparedValue), filter.getValue());
    }

    private void init(List<Filter> filter, List<Field> column, List<FieldMapping> fieldMapping) {
        Assert.notEmpty(column, (String)"\u8bfb\u53d6\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a.");
        Assert.notEmpty(fieldMapping, (String)"\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a.");
        this.enabledFilter = !CollectionUtils.isEmpty(filter);
        if (this.enabledFilter) {
            this.add = filter.stream().filter((? super T f) -> StringUtil.equals((CharSequence)f.getOperation(), (CharSequence)OperationEnum.AND.getName())).collect(Collectors.toList());
            this.or = filter.stream().filter((? super T f) -> StringUtil.equals((CharSequence)f.getOperation(), (CharSequence)OperationEnum.OR.getName())).collect(Collectors.toList());
        }
        this.index = new LinkedList<Node>();
        int size = column.size();
        String k = null;
        Field field = null;
        for (int i = 0; i < size; ++i) {
            field = column.get(i);
            k = field.isUnmodifiabled() ? field.getLabelName() : field.getName();
            this.index.add(new Node(k, i));
        }
        Assert.notEmpty(this.index, (String)"\u540c\u6b65\u6620\u5c04\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a.");
        this.indexSize = this.index.size();
    }

    public TableGroup getTableGroup() {
        return this.tableGroup;
    }

    final class Node {
        String name;
        int i;

        public Node(String name, int i) {
            this.name = name;
            this.i = i;
        }
    }
}

