/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.sdk.model.Field;

public class Picker {
    private List<Field> sourceFields = new ArrayList<Field>();
    private List<Field> targetFields = new ArrayList<Field>();

    public Picker(List<FieldMapping> fieldMapping) {
        if (!CollectionUtils.isEmpty(fieldMapping)) {
            fieldMapping.forEach(m -> {
                if (m.getSource() != null) {
                    this.sourceFields.add(m.getSource());
                }
                if (m.getTarget() != null) {
                    this.targetFields.add(m.getTarget());
                }
            });
        }
    }

    public List<Map> pickTargetData(List<Map> source) {
        ArrayList<Map> targetMapList = new ArrayList<Map>();
        if (!CollectionUtils.isEmpty(source)) {
            int size = source.size();
            int sFieldSize = this.sourceFields.size();
            HashMap<String, Object> target = null;
            for (int i = 0; i < size; ++i) {
                target = new HashMap<String, Object>();
                this.exchange(sFieldSize, this.sourceFields, this.targetFields, source.get(i), target);
                targetMapList.add(target);
            }
        }
        return targetMapList;
    }

    public Map pickSourceData(Map target) {
        HashMap<String, Object> source = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty((Map)target)) {
            this.exchange(this.targetFields.size(), this.targetFields, this.sourceFields, target, source);
        }
        return source;
    }

    private void exchange(int fieldSize, List<Field> sFields, List<Field> tFields, Map<String, Object> source, Map<String, Object> target) {
        Field sField = null;
        Field tField = null;
        Object v = null;
        String tFieldName = null;
        for (int k = 0; k < fieldSize; ++k) {
            sField = sFields.get(k);
            tField = tFields.get(k);
            if (null == sField || null == tField) continue;
            v = source.get(sField.isUnmodifiabled() ? sField.getLabelName() : sField.getName());
            tFieldName = tField.getName();
            if (!target.containsKey(tFieldName)) {
                target.put(tFieldName, v);
                continue;
            }
            String mergedValue = StringUtil.toString((Object)target.get(tFieldName)) + StringUtil.toString((Object)v);
            target.put(tFieldName, mergedValue);
        }
    }

    public List<Field> getTargetFields() {
        ArrayList fields = new ArrayList();
        HashSet keys = new HashSet();
        this.targetFields.forEach(f -> {
            if (!keys.contains(f.getName())) {
                fields.add(f);
                keys.add(f.getName());
            }
        });
        return Collections.unmodifiableList(fields);
    }

    public Map<String, Field> getTargetFieldMap() {
        return this.targetFields.stream().filter(f -> null != f).collect(Collectors.toMap(Field::getName, f -> f, (k1, k2) -> k1));
    }
}

