/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.strategy.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.dbsyncer.common.model.Result;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.CacheService;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.flush.BufferActuator;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.StorageRequest;
import org.dbsyncer.parser.model.SystemConfig;
import org.dbsyncer.parser.strategy.FlushStrategy;
import org.dbsyncer.storage.enums.StorageDataStatusEnum;
import org.dbsyncer.storage.impl.SnowflakeIdWorker;
import org.dbsyncer.storage.util.BinlogMessageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public final class FlushStrategyImpl
implements FlushStrategy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private SnowflakeIdWorker snowflakeIdWorker;
    @Resource
    private CacheService cacheService;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private LogService logService;
    @Resource
    private BufferActuator storageBufferActuator;

    @Override
    public void flushFullData(String metaId, Result result, String event) {
        if (!this.getSystemConfig().isEnableStorageWriteFull()) {
            this.refreshTotal(metaId, result);
            if (!CollectionUtils.isEmpty((Collection)result.getFailData())) {
                this.logger.error(result.getError().toString());
                LogType.TableGroupLog logType = LogType.TableGroupLog.FULL_FAILED;
                this.logService.log(logType, "%s:%s:%s", result.getTargetTableGroupName(), logType.getMessage(), result.getError().toString());
            }
            return;
        }
        this.flush(metaId, result, event);
    }

    @Override
    public void flushIncrementData(String metaId, Result result, String event) {
        this.flush(metaId, result, event);
    }

    private void asyncWrite(String metaId, String tableGroupId, String targetTableGroupName, String event, boolean success, List<Map> data, String error) {
        long now = Instant.now().toEpochMilli();
        data.forEach(r -> {
            HashMap<String, Object> row = new HashMap<String, Object>();
            row.put("id", String.valueOf(this.snowflakeIdWorker.nextId()));
            row.put("success", success ? StorageDataStatusEnum.SUCCESS.getValue() : StorageDataStatusEnum.FAIL.getValue());
            row.put("tableGroupId", tableGroupId);
            row.put("targetTableName", targetTableGroupName);
            row.put("event", event);
            row.put("error", error);
            row.put("createTime", now);
            try {
                byte[] bytes = BinlogMessageUtil.toBinlogMap((Map)r).toByteArray();
                row.put("data", bytes);
            }
            catch (Exception e) {
                this.logger.warn("\u53ef\u80fd\u5b58\u5728Blob\u6216inputStream\u5927\u6587\u4ef6\u7c7b\u578b, \u65e0\u6cd5\u5e8f\u5217\u5316:{}", r);
            }
            this.storageBufferActuator.offer(new StorageRequest(metaId, row));
        });
    }

    private void refreshTotal(String metaId, Result writer) {
        Assert.hasText((String)metaId, (String)"Meta id can not be empty.");
        Meta meta = this.cacheService.get(metaId, Meta.class);
        if (meta != null) {
            meta.getFail().getAndAdd(writer.getFailData().size());
            meta.getSuccess().getAndAdd(writer.getSuccessData().size());
            meta.setUpdateTime(Instant.now().toEpochMilli());
        }
    }

    private void flush(String metaId, Result result, String event) {
        this.refreshTotal(metaId, result);
        if (this.getSystemConfig().isEnableStorageWriteFail() && !CollectionUtils.isEmpty((Collection)result.getFailData())) {
            String error = StringUtil.substring((String)result.getError().toString(), (int)0, (int)this.getSystemConfig().getMaxStorageErrorLength());
            this.asyncWrite(metaId, result.getTableGroupId(), result.getTargetTableGroupName(), event, false, result.getFailData(), error);
        }
        if (this.getSystemConfig().isEnableStorageWriteSuccess() && !CollectionUtils.isEmpty((Collection)result.getSuccessData())) {
            this.asyncWrite(metaId, result.getTableGroupId(), result.getTargetTableGroupName(), event, true, result.getSuccessData(), "");
        }
    }

    private SystemConfig getSystemConfig() {
        return this.profileComponent.getSystemConfig();
    }
}

