/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.enums;

import org.dbsyncer.biz.BizException;
import org.dbsyncer.common.util.StringUtil;

public enum MetricEnum {
    THREADS_LIVE("jvm.threads.live", "\u5e94\u7528\u7ebf\u7a0b", "\u6d3b\u8dc3\u6570"),
    THREADS_PEAK("jvm.threads.peak", "\u5e94\u7528\u7ebf\u7a0b", "\u5cf0\u503c\u6570"),
    MEMORY_USED("jvm.memory.used", "\u5185\u5b58", "\u5df2\u7528"),
    MEMORY_COMMITTED("jvm.memory.committed", "\u5185\u5b58", "\u7a7a\u95f2"),
    MEMORY_MAX("jvm.memory.max", "\u5185\u5b58", "\u603b\u5171"),
    GC_PAUSE("jvm.gc.pause", "GC", "\u5df2\u7528"),
    CPU_USAGE("system.cpu.usage", "CPU", "\u5df2\u7528");

    private String code;
    private String group;
    private String metricName;

    private MetricEnum(String code, String group, String metricName) {
        this.code = code;
        this.group = group;
        this.metricName = metricName;
    }

    public static MetricEnum getMetric(String code) throws BizException {
        for (MetricEnum e : MetricEnum.values()) {
            if (!StringUtil.equals((CharSequence)code, (CharSequence)e.getCode())) continue;
            return e;
        }
        throw new BizException(String.format("Metric code \"%s\" does not exist.", code));
    }

    public String getCode() {
        return this.code;
    }

    public String getGroup() {
        return this.group;
    }

    public String getMetricName() {
        return this.metricName;
    }
}

