/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import java.time.Instant;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dbsyncer.biz.BizException;
import org.dbsyncer.biz.ConnectorService;
import org.dbsyncer.biz.MappingService;
import org.dbsyncer.biz.MonitorService;
import org.dbsyncer.biz.TableGroupService;
import org.dbsyncer.biz.checker.impl.mapping.MappingChecker;
import org.dbsyncer.biz.impl.BaseServiceImpl;
import org.dbsyncer.biz.vo.ConnectorVo;
import org.dbsyncer.biz.vo.MappingVo;
import org.dbsyncer.biz.vo.MetaVo;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.JsonUtil;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.base.ConnectorFactory;
import org.dbsyncer.manager.ManagerFactory;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Connector;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.connector.ConnectorInstance;
import org.dbsyncer.sdk.enums.ModelEnum;
import org.dbsyncer.storage.impl.SnowflakeIdWorker;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MappingServiceImpl
extends BaseServiceImpl
implements MappingService {
    @Resource
    private MappingChecker mappingChecker;
    @Resource
    private TableGroupService tableGroupService;
    @Resource
    private ConnectorService connectorService;
    @Resource
    private SnowflakeIdWorker snowflakeIdWorker;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private MonitorService monitorService;
    @Resource
    private ManagerFactory managerFactory;
    @Resource
    private ConnectorFactory connectorFactory;

    @Override
    public String add(Map<String, String> params) {
        ConfigModel model = this.mappingChecker.checkAddConfigModel(params);
        this.log((LogType)LogType.MappingLog.INSERT, (Mapping)model);
        String id = this.profileComponent.addConfigModel(model);
        String autoMatchTable = params.get("autoMatchTable");
        if (StringUtil.isNotBlank((CharSequence)autoMatchTable)) {
            this.matchSimilarTable(model);
        }
        return id;
    }

    @Override
    public String copy(String id) {
        Mapping mapping = this.profileComponent.getMapping(id);
        Assert.notNull((Object)mapping, (String)"The mapping id is invalid.");
        String json = JsonUtil.objToJson((Object)mapping);
        Mapping newMapping = (Mapping)JsonUtil.jsonToObj((String)json, Mapping.class);
        newMapping.setName(mapping.getName() + "(\u590d\u5236)");
        newMapping.setId(String.valueOf(this.snowflakeIdWorker.nextId()));
        newMapping.setUpdateTime(Long.valueOf(Instant.now().toEpochMilli()));
        this.mappingChecker.addMeta(newMapping);
        this.profileComponent.addConfigModel((ConfigModel)newMapping);
        this.log((LogType)LogType.MappingLog.COPY, newMapping);
        List groupList = this.profileComponent.getTableGroupAll(mapping.getId());
        if (!CollectionUtils.isEmpty((Collection)groupList)) {
            groupList.forEach(tableGroup -> {
                String tableGroupJson = JsonUtil.objToJson((Object)tableGroup);
                TableGroup newTableGroup = (TableGroup)JsonUtil.jsonToObj((String)tableGroupJson, TableGroup.class);
                newTableGroup.setId(String.valueOf(this.snowflakeIdWorker.nextId()));
                newTableGroup.setMappingId(newMapping.getId());
                this.profileComponent.addTableGroup(newTableGroup);
                this.log((LogType)LogType.TableGroupLog.COPY, newTableGroup);
            });
        }
        return String.format("\u590d\u5236\u6210\u529f[%s]", newMapping.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String edit(Map<String, String> params) {
        String id = params.get("id");
        Mapping mapping = this.assertMappingExist(id);
        Object object = LOCK;
        synchronized (object) {
            this.assertRunning(mapping.getMetaId());
            Mapping model = (Mapping)this.mappingChecker.checkEditConfigModel(params);
            this.log((LogType)LogType.MappingLog.UPDATE, model);
            this.mappingChecker.batchMergeTableGroupConfig(model, params);
            return this.profileComponent.editConfigModel((ConfigModel)model);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String remove(String id) {
        Mapping mapping = this.assertMappingExist(id);
        String metaId = mapping.getMetaId();
        Meta meta = this.profileComponent.getMeta(metaId);
        Object object = LOCK;
        synchronized (object) {
            this.assertRunning(metaId);
            this.monitorService.clearData(metaId);
            this.log((LogType)LogType.MetaLog.CLEAR, (ConfigModel)meta);
            this.profileComponent.removeConfigModel(metaId);
            this.log((LogType)LogType.MetaLog.DELETE, (ConfigModel)meta);
            List groupList = this.profileComponent.getTableGroupAll(id);
            if (!CollectionUtils.isEmpty((Collection)groupList)) {
                groupList.forEach(t -> this.profileComponent.removeTableGroup(t.getId()));
            }
            this.profileComponent.removeConfigModel(id);
            this.log((LogType)LogType.MappingLog.DELETE, mapping);
        }
        return "\u9a71\u52a8\u5220\u9664\u6210\u529f";
    }

    @Override
    public MappingVo getMapping(String id) {
        Mapping mapping = this.profileComponent.getMapping(id);
        return this.convertMapping2Vo(mapping);
    }

    @Override
    public List<MappingVo> getMappingAll() {
        List<MappingVo> list = this.profileComponent.getMappingAll().stream().map(m -> this.convertMapping2Vo((Mapping)m)).sorted(Comparator.comparing(ConfigModel::getUpdateTime).reversed()).collect(Collectors.toList());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String start(String id) {
        Mapping mapping = this.assertMappingExist(id);
        String metaId = mapping.getMetaId();
        this.clearMetaIfFinished(metaId);
        Object object = LOCK;
        synchronized (object) {
            this.assertRunning(metaId);
            this.managerFactory.start(mapping);
            this.log((LogType)LogType.MappingLog.RUNNING, mapping);
        }
        return "\u9a71\u52a8\u542f\u52a8\u6210\u529f";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String stop(String id) {
        Mapping mapping = this.assertMappingExist(id);
        Object object = LOCK;
        synchronized (object) {
            if (!this.isRunning(mapping.getMetaId())) {
                throw new BizException("\u9a71\u52a8\u5df2\u505c\u6b62.");
            }
            this.managerFactory.close(mapping);
            this.log((LogType)LogType.MappingLog.STOP, mapping);
            String model = ModelEnum.getModelEnum((String)mapping.getModel()).getName();
            this.sendNotifyMessage("\u505c\u6b62\u9a71\u52a8", String.format("\u624b\u52a8\u505c\u6b62\u9a71\u52a8\uff1a%s(%s)", mapping.getName(), model));
        }
        return "\u9a71\u52a8\u505c\u6b62\u6210\u529f";
    }

    @Override
    public String refreshMappingTables(String id) {
        Mapping mapping = this.profileComponent.getMapping(id);
        Assert.notNull((Object)mapping, (String)"The mapping id is invalid.");
        this.updateConnectorTables(mapping.getSourceConnectorId());
        this.updateConnectorTables(mapping.getTargetConnectorId());
        return "\u5237\u65b0\u9a71\u52a8\u8868\u6210\u529f";
    }

    private void updateConnectorTables(String connectorId) {
        Connector connector = this.profileComponent.getConnector(connectorId);
        Assert.notNull((Object)connector, (String)"The connector id is invalid.");
        ConnectorInstance connectorInstance = this.connectorFactory.connect(connector.getConfig());
        connector.setTable(this.connectorFactory.getTable(connectorInstance));
        this.profileComponent.editConfigModel((ConfigModel)connector);
    }

    private MappingVo convertMapping2Vo(Mapping mapping) {
        String model = mapping.getModel();
        Assert.notNull((Object)mapping, (String)"Mapping can not be null.");
        Connector s = this.profileComponent.getConnector(mapping.getSourceConnectorId());
        Connector t = this.profileComponent.getConnector(mapping.getTargetConnectorId());
        ConnectorVo sConn = new ConnectorVo(this.connectorService.isAlive(s.getId()));
        BeanUtils.copyProperties((Object)s, (Object)((Object)sConn));
        ConnectorVo tConn = new ConnectorVo(this.connectorService.isAlive(t.getId()));
        BeanUtils.copyProperties((Object)t, (Object)((Object)tConn));
        Meta meta = this.profileComponent.getMeta(mapping.getMetaId());
        Assert.notNull((Object)meta, (String)"Meta can not be null.");
        MetaVo metaVo = new MetaVo(ModelEnum.getModelEnum((String)model).getName(), mapping.getName());
        BeanUtils.copyProperties((Object)meta, (Object)((Object)metaVo));
        MappingVo vo = new MappingVo(sConn, tConn, metaVo);
        BeanUtils.copyProperties((Object)mapping, (Object)((Object)vo));
        return vo;
    }

    private Mapping assertMappingExist(String mappingId) {
        Mapping mapping = this.profileComponent.getMapping(mappingId);
        Assert.notNull((Object)mapping, (String)"\u9a71\u52a8\u4e0d\u5b58\u5728.");
        return mapping;
    }

    private void matchSimilarTable(ConfigModel model) {
        Mapping mapping = (Mapping)model;
        Connector s = this.profileComponent.getConnector(mapping.getSourceConnectorId());
        Connector t = this.profileComponent.getConnector(mapping.getTargetConnectorId());
        if (CollectionUtils.isEmpty((Collection)s.getTable()) || CollectionUtils.isEmpty((Collection)t.getTable())) {
            return;
        }
        List<String> sTables = s.getTable().stream().map(table -> table.getName()).collect(Collectors.toList());
        List tTables = t.getTable().stream().map(table -> table.getName()).collect(Collectors.toList());
        sTables.retainAll(tTables);
        if (!CollectionUtils.isEmpty(sTables)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("mappingId", mapping.getId());
            sTables.forEach(table -> {
                params.put("sourceTable", (String)table);
                params.put("targetTable", (String)table);
                this.tableGroupService.add(params);
            });
            this.mappingChecker.updateMeta(mapping);
        }
    }

    private void clearMetaIfFinished(String metaId) {
        Meta meta = this.profileComponent.getMeta(metaId);
        Assert.notNull((Object)meta, (String)"Mapping meta can not be null.");
        if (meta.getTotal().get() <= meta.getSuccess().get() + meta.getFail().get()) {
            meta.getFail().set(0L);
            meta.getSuccess().set(0L);
            this.profileComponent.editConfigModel((ConfigModel)meta);
        }
    }
}

