/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.dbsyncer.biz.ConnectorService;
import org.dbsyncer.biz.MappingService;
import org.dbsyncer.biz.ProjectGroupService;
import org.dbsyncer.biz.checker.Checker;
import org.dbsyncer.biz.impl.BaseServiceImpl;
import org.dbsyncer.biz.vo.MappingVo;
import org.dbsyncer.biz.vo.ProjectGroupVo;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Connector;
import org.dbsyncer.parser.model.ProjectGroup;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ProjectGroupServiceImpl
extends BaseServiceImpl
implements ProjectGroupService {
    @Resource
    private ConnectorService connectorService;
    @Resource
    private MappingService mappingService;
    @Resource
    private ProfileComponent profileComponent;
    @Resource
    private Checker projectGroupChecker;

    @Override
    public String add(Map<String, String> params) {
        ConfigModel model = this.projectGroupChecker.checkAddConfigModel(params);
        this.log((LogType)LogType.ConnectorLog.INSERT, model);
        return this.profileComponent.addConfigModel(model);
    }

    @Override
    public String edit(Map<String, String> params) {
        ConfigModel model = this.projectGroupChecker.checkEditConfigModel(params);
        this.log((LogType)LogType.ConnectorLog.UPDATE, model);
        return this.profileComponent.editConfigModel(model);
    }

    @Override
    public String remove(String id) {
        ProjectGroup projectGroup = this.profileComponent.getProjectGroup(id);
        this.log((LogType)LogType.ConnectorLog.DELETE, (ConfigModel)projectGroup);
        Assert.notNull((Object)projectGroup, (String)"\u8be5\u5206\u7ec4\u5df2\u88ab\u5220\u9664");
        this.profileComponent.removeConfigModel(id);
        return "\u5220\u9664\u5206\u7ec4\u6210\u529f!";
    }

    @Override
    public ProjectGroupVo getProjectGroup(String id) {
        List mappingIds;
        ProjectGroupVo vo = new ProjectGroupVo();
        List<Connector> connectors = this.connectorService.getConnectorAll();
        vo.setConnectorSize(CollectionUtils.isEmpty(connectors) ? 0 : connectors.size());
        if (StringUtil.isBlank((CharSequence)id)) {
            vo.setConnectors(connectors);
            vo.setMappings(this.mappingService.getMappingAll());
            return vo;
        }
        ProjectGroup projectGroup = this.profileComponent.getProjectGroup(id);
        Assert.notNull((Object)projectGroup, (String)"\u8be5\u5206\u7ec4\u5df2\u88ab\u5220\u9664");
        BeanUtils.copyProperties((Object)projectGroup, (Object)((Object)vo));
        vo.setConnectors(Collections.EMPTY_LIST);
        vo.setMappings(Collections.EMPTY_LIST);
        List connectorIds = projectGroup.getConnectorIds();
        if (!CollectionUtils.isEmpty((Collection)connectorIds)) {
            HashSet connectorIdSet = new HashSet(connectorIds);
            if (!CollectionUtils.isEmpty(connectors)) {
                vo.setConnectors(connectors.stream().filter(connector -> connectorIdSet.contains(connector.getId())).collect(Collectors.toList()));
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(mappingIds = projectGroup.getMappingIds()))) {
            HashSet mappingIdSet = new HashSet(mappingIds);
            List<MappingVo> mappings = this.mappingService.getMappingAll();
            if (!CollectionUtils.isEmpty(mappings)) {
                vo.setMappings(mappings.stream().filter(mapping -> mappingIdSet.contains(mapping.getId())).collect(Collectors.toList()));
            }
        }
        return vo;
    }

    @Override
    public List<ProjectGroup> getProjectGroupAll() {
        return this.profileComponent.getProjectGroupAll();
    }
}

