/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.biz.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.dbsyncer.biz.TableGroupService;
import org.dbsyncer.biz.checker.Checker;
import org.dbsyncer.biz.checker.impl.tablegroup.TableGroupChecker;
import org.dbsyncer.biz.impl.BaseServiceImpl;
import org.dbsyncer.common.util.CollectionUtils;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.ConfigModel;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.TableGroup;
import org.dbsyncer.sdk.model.Field;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TableGroupServiceImpl
extends BaseServiceImpl
implements TableGroupService {
    @Resource
    private Checker tableGroupChecker;
    @Resource
    private ProfileComponent profileComponent;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String add(Map<String, String> params) {
        String mappingId = params.get("mappingId");
        this.assertRunning(this.profileComponent.getMapping(mappingId));
        Object object = LOCK;
        synchronized (object) {
            String[] sourceTableArray = StringUtil.split((String)params.get("sourceTable"), (String)"|");
            String[] targetTableArray = StringUtil.split((String)params.get("targetTable"), (String)"|");
            int tableSize = sourceTableArray.length;
            Assert.isTrue((tableSize == targetTableArray.length ? 1 : 0) != 0, (String)"\u6570\u636e\u6e90\u8868\u548c\u76ee\u6807\u6e90\u8868\u5173\u7cfb\u5fc5\u987b\u4e3a\u4e00\u7ec4");
            String id = null;
            for (int i = 0; i < tableSize; ++i) {
                params.put("sourceTable", sourceTableArray[i]);
                params.put("targetTable", targetTableArray[i]);
                TableGroup model = (TableGroup)this.tableGroupChecker.checkAddConfigModel(params);
                this.log((LogType)LogType.TableGroupLog.INSERT, model);
                int tableGroupCount = this.profileComponent.getTableGroupCount(mappingId);
                model.setIndex(tableGroupCount + 1);
                id = this.profileComponent.addTableGroup(model);
            }
            this.mergeMappingColumn(mappingId);
            return 1 < tableSize ? String.valueOf(tableSize) : id;
        }
    }

    @Override
    public String edit(Map<String, String> params) {
        String id = params.get("id");
        TableGroup tableGroup = this.profileComponent.getTableGroup(id);
        Assert.notNull((Object)tableGroup, (String)"Can not find tableGroup.");
        this.assertRunning(this.profileComponent.getMapping(tableGroup.getMappingId()));
        TableGroup model = (TableGroup)this.tableGroupChecker.checkEditConfigModel(params);
        this.log((LogType)LogType.TableGroupLog.UPDATE, model);
        return this.profileComponent.editTableGroup(model);
    }

    @Override
    public String refreshFields(String id) {
        TableGroup tableGroup = this.profileComponent.getTableGroup(id);
        Assert.notNull((Object)tableGroup, (String)"Can not find tableGroup.");
        this.assertRunning(this.profileComponent.getMapping(tableGroup.getMappingId()));
        TableGroupChecker checker = (TableGroupChecker)this.tableGroupChecker;
        checker.refreshTableFields(tableGroup);
        return this.profileComponent.editTableGroup(tableGroup);
    }

    @Override
    public boolean remove(String mappingId, String ids) {
        Assert.hasText((String)mappingId, (String)"Mapping id can not be null");
        Assert.hasText((String)ids, (String)"TableGroup ids can not be null");
        this.assertRunning(this.profileComponent.getMapping(mappingId));
        ((Stream)Stream.of(StringUtil.split((String)ids, (String)",")).parallel()).forEach(id -> {
            TableGroup model = this.profileComponent.getTableGroup(id);
            this.log((LogType)LogType.TableGroupLog.DELETE, model);
            this.profileComponent.removeTableGroup(id);
        });
        this.mergeMappingColumn(mappingId);
        this.resetTableGroupAllIndex(mappingId);
        return true;
    }

    @Override
    public TableGroup getTableGroup(String id) {
        TableGroup tableGroup = this.profileComponent.getTableGroup(id);
        Assert.notNull((Object)tableGroup, (String)"TableGroup can not be null");
        return tableGroup;
    }

    @Override
    public List<TableGroup> getTableGroupAll(String mappingId) {
        return this.profileComponent.getSortedTableGroupAll(mappingId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTableGroupAllIndex(String mappingId) {
        Object object = LOCK;
        synchronized (object) {
            int size;
            List list = this.profileComponent.getSortedTableGroupAll(mappingId);
            for (int i = size = list.size(); i > 0; --i) {
                TableGroup g = (TableGroup)list.get(size - i);
                g.setIndex(i);
                this.profileComponent.editConfigModel((ConfigModel)g);
            }
        }
    }

    private void mergeMappingColumn(String mappingId) {
        List groups = this.profileComponent.getTableGroupAll(mappingId);
        Mapping mapping = this.profileComponent.getMapping(mappingId);
        Assert.notNull((Object)mapping, (String)"mapping not exist.");
        List<Field> sourceColumn = null;
        List<Field> targetColumn = null;
        for (TableGroup g : groups) {
            sourceColumn = this.pickCommonFields(sourceColumn, g.getSourceTable().getColumn());
            targetColumn = this.pickCommonFields(targetColumn, g.getTargetTable().getColumn());
        }
        mapping.setSourceColumn(sourceColumn);
        mapping.setTargetColumn(targetColumn);
        this.profileComponent.editConfigModel((ConfigModel)mapping);
    }

    private List<Field> pickCommonFields(List<Field> column, List<Field> target) {
        if (CollectionUtils.isEmpty(column) || CollectionUtils.isEmpty(target)) {
            return target;
        }
        ArrayList<Field> list = new ArrayList<Field>();
        HashSet keys = new HashSet();
        column.forEach(f -> keys.add(f.getName()));
        target.forEach(f -> {
            if (keys.contains(f.getName())) {
                list.add((Field)f);
            }
        });
        return list;
    }
}

