/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.mysql;

import java.util.List;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.mysql.cdc.MySQLListener;
import org.dbsyncer.connector.mysql.storage.MySQLStorageService;
import org.dbsyncer.connector.mysql.validator.MySQLConfigValidator;
import org.dbsyncer.sdk.config.ReaderConfig;
import org.dbsyncer.sdk.connector.ConfigValidator;
import org.dbsyncer.sdk.connector.database.AbstractDatabaseConnector;
import org.dbsyncer.sdk.enums.ListenerTypeEnum;
import org.dbsyncer.sdk.listener.DatabaseQuartzListener;
import org.dbsyncer.sdk.listener.Listener;
import org.dbsyncer.sdk.model.PageSql;
import org.dbsyncer.sdk.storage.StorageService;
import org.dbsyncer.sdk.util.PrimaryKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MySQLConnector
extends AbstractDatabaseConnector {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String TYPE = "MySQL";
    private final MySQLConfigValidator configValidator = new MySQLConfigValidator();

    public String getConnectorType() {
        return "MySQL";
    }

    public ConfigValidator getConfigValidator() {
        return this.configValidator;
    }

    public Listener getListener(String listenerType) {
        if (ListenerTypeEnum.isTiming((String)listenerType)) {
            return new DatabaseQuartzListener();
        }
        if (ListenerTypeEnum.isLog((String)listenerType)) {
            return new MySQLListener();
        }
        return null;
    }

    public StorageService getStorageService() {
        return new MySQLStorageService();
    }

    public String generateUniqueCode() {
        return "/*dbs*/";
    }

    public String buildSqlWithQuotation() {
        return "`";
    }

    public String getPageSql(PageSql config) {
        StringBuilder sql = new StringBuilder(config.getQuerySql());
        if (PrimaryKeyUtil.isSupportedCursor((List)config.getFields())) {
            this.appendOrderByPk(config, sql);
        }
        sql.append(" LIMIT ?,?");
        return sql.toString();
    }

    public String getPageCursorSql(PageSql config) {
        if (!PrimaryKeyUtil.isSupportedCursor((List)config.getFields())) {
            this.logger.debug("\u4e0d\u652f\u6301\u6e38\u6807\u67e5\u8be2\uff0c\u4e3b\u952e\u5305\u542b\u975e\u6570\u5b57\u7c7b\u578b");
            return "";
        }
        StringBuilder sql = new StringBuilder(config.getQuerySql());
        boolean skipFirst = false;
        if (StringUtil.isBlank((CharSequence)config.getQueryFilter())) {
            skipFirst = true;
            sql.append(" WHERE ");
        }
        String quotation = this.buildSqlWithQuotation();
        List primaryKeys = config.getPrimaryKeys();
        PrimaryKeyUtil.buildSql((StringBuilder)sql, (List)primaryKeys, (String)quotation, (String)" AND ", (String)" > ? ", (boolean)skipFirst);
        this.appendOrderByPk(config, sql);
        sql.append(" LIMIT ?,?");
        return sql.toString();
    }

    public Object[] getPageArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        int pageIndex = config.getPageIndex();
        return new Object[]{(pageIndex - 1) * pageSize, pageSize};
    }

    public Object[] getPageCursorArgs(ReaderConfig config) {
        int pageSize = config.getPageSize();
        Object[] cursors = config.getCursors();
        if (null == cursors) {
            return new Object[]{0, pageSize};
        }
        int cursorsLen = cursors.length;
        Object[] newCursors = new Object[cursorsLen + 2];
        System.arraycopy(cursors, 0, newCursors, 0, cursorsLen);
        newCursors[cursorsLen] = 0;
        newCursors[cursorsLen + 1] = pageSize;
        return newCursors;
    }

    public boolean enableCursor() {
        return true;
    }
}

