/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.lucene.document.LatLonDocValuesField;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.document.ShapeField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.geo.LatLonGeometry;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.geo.GeoShapeUtils;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLatLonPointIndexFieldData;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeQueryable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;

public class GeoPointFieldMapper
extends AbstractPointGeometryFieldMapper<List<ParsedGeoPoint>, List<? extends GeoPoint>> {
    public static final String CONTENT_TYPE = "geo_point";
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())));
    private final Builder builder;

    private static Builder builder(FieldMapper in) {
        return ((GeoPointFieldMapper)in).builder;
    }

    public GeoPointFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Indexer<List<ParsedGeoPoint>, List<? extends GeoPoint>> indexer, AbstractGeometryFieldMapper.Parser<List<ParsedGeoPoint>> parser, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, builder.ignoreMalformed.get(), builder.ignoreZValue.get(), builder.nullValue.get(), copyTo, indexer, parser);
        this.builder = builder;
    }

    @Override
    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), this.builder.ignoreMalformed.getDefaultValue().value()).init(this);
    }

    @Override
    protected void addStoredFields(ParseContext context, List<? extends GeoPoint> points) {
        for (GeoPoint geoPoint : points) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), geoPoint.toString()));
        }
    }

    @Override
    protected void addMultiFields(ParseContext context, List<? extends GeoPoint> points) throws IOException {
        if (points.isEmpty()) {
            return;
        }
        StringBuilder s = new StringBuilder();
        if (points.size() > 1) {
            s.append('[');
        }
        s.append(points.get(0).geohash());
        for (int i = 1; i < points.size(); ++i) {
            s.append(',');
            s.append(points.get(i).geohash());
        }
        if (points.size() > 1) {
            s.append(']');
        }
        this.multiFields.parse(this, context.createExternalValueContext(s));
    }

    @Override
    protected void addDocValuesFields(String name, List<? extends GeoPoint> points, List<IndexableField> fields, ParseContext context) {
        for (GeoPoint geoPoint : points) {
            context.doc().add((IndexableField)new LatLonDocValuesField(this.fieldType().name(), geoPoint.lat(), geoPoint.lon()));
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<AbstractPointGeometryFieldMapper.ParsedPoint> nullValue;
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).indexed.get(), true);
        final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).hasDocValues.get(), true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).stored.get(), false);
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), ignoreMalformedByDefault);
            this.nullValue = AbstractPointGeometryFieldMapper.nullValueParam(m -> GeoPointFieldMapper.builder((FieldMapper)m).nullValue.get(), (n, c, o) -> Builder.parseNullValue(o, this.ignoreZValue.get().value(), this.ignoreMalformed.get().value()), () -> null).acceptsNull();
        }

        @Override
        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.hasDocValues, this.indexed, this.stored, this.ignoreMalformed, this.ignoreZValue, this.nullValue, this.meta);
        }

        public Builder docValues(boolean hasDocValues) {
            this.hasDocValues.setValue(hasDocValues);
            return this;
        }

        private static ParsedGeoPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            if (nullValue == null) {
                return null;
            }
            ParsedGeoPoint point = new ParsedGeoPoint();
            GeoUtils.parseGeoPoint(nullValue, (GeoPoint)point, ignoreZValue);
            if (!ignoreMalformed) {
                if (point.lat() > 90.0 || point.lat() < -90.0) {
                    throw new IllegalArgumentException("illegal latitude value [" + point.lat() + "]");
                }
                if (point.lon() > 180.0 || point.lon() < -180.0) {
                    throw new IllegalArgumentException("illegal longitude value [" + point.lon() + "]");
                }
            } else {
                GeoUtils.normalizePoint(point);
            }
            return point;
        }

        @Override
        public FieldMapper build(ContentPath contentPath) {
            AbstractPointGeometryFieldMapper.PointParser<ParsedGeoPoint> geoParser = new AbstractPointGeometryFieldMapper.PointParser<ParsedGeoPoint>(this.name, ParsedGeoPoint::new, (parser, point) -> {
                GeoUtils.parseGeoPoint(parser, (GeoPoint)point, (boolean)this.ignoreZValue.get().value());
                return point;
            }, (ParsedGeoPoint)this.nullValue.get(), this.ignoreZValue.get().value(), this.ignoreMalformed.get().value());
            GeoPointFieldType ft = new GeoPointFieldType(this.buildFullName(contentPath), (boolean)this.indexed.get(), (boolean)this.stored.get(), (boolean)this.hasDocValues.get(), geoParser, this.meta.get());
            return new GeoPointFieldMapper(this.name, ft, this.multiFieldsBuilder.build(this, contentPath), this.copyTo.build(), new GeoPointIndexer(ft), geoParser, this);
        }
    }

    protected static class GeoPointIndexer
    implements AbstractGeometryFieldMapper.Indexer<List<ParsedGeoPoint>, List<? extends GeoPoint>> {
        protected final GeoPointFieldType fieldType;

        GeoPointIndexer(GeoPointFieldType fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public List<? extends GeoPoint> prepareForIndexing(List<ParsedGeoPoint> geoPoints) {
            if (geoPoints == null || geoPoints.isEmpty()) {
                return Collections.emptyList();
            }
            return geoPoints;
        }

        @Override
        public Class<List<? extends GeoPoint>> processedClass() {
            return List.class;
        }

        @Override
        public List<IndexableField> indexShape(ParseContext context, List<? extends GeoPoint> points) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>(points.size());
            for (GeoPoint geoPoint : points) {
                fields.add((IndexableField)new LatLonPoint(this.fieldType.name(), geoPoint.lat(), geoPoint.lon()));
            }
            return fields;
        }
    }

    protected static class ParsedGeoPoint
    extends GeoPoint
    implements AbstractPointGeometryFieldMapper.ParsedPoint {
        protected ParsedGeoPoint() {
        }

        @Override
        public void validate(String fieldName) {
            if (this.lat() > 90.0 || this.lat() < -90.0) {
                throw new IllegalArgumentException("illegal latitude value [" + this.lat() + "] for " + fieldName);
            }
            if (this.lon() > 180.0 || this.lon() < -180.0) {
                throw new IllegalArgumentException("illegal longitude value [" + this.lon() + "] for " + fieldName);
            }
        }

        @Override
        public void normalize(String name) {
            if (!this.isNormalizable(this.lat()) || !this.isNormalizable(this.lon())) {
                throw new ElasticsearchParseException("cannot normalize the point - not a number", new Object[0]);
            }
            GeoUtils.normalizePoint(this);
        }

        @Override
        public boolean isNormalizable(double coord) {
            return !Double.isNaN(coord) && !Double.isInfinite(coord);
        }

        @Override
        public void resetCoords(double x, double y) {
            this.reset(y, x);
        }

        @Override
        public Point asGeometry() {
            return new Point(this.lon(), this.lat());
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof GeoPoint)) {
                return false;
            }
            GeoPoint o = (GeoPoint)other;
            double oLat = o.lat();
            double oLon = o.lon();
            if (Double.compare(oLat, this.lat) != 0) {
                return false;
            }
            return Double.compare(oLon, this.lon) == 0;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    public static class GeoPointFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType
    implements GeoShapeQueryable {
        private GeoPointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, AbstractGeometryFieldMapper.Parser<?> parser, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, true, parser, meta);
        }

        public GeoPointFieldType(String name) {
            this(name, true, false, true, (AbstractGeometryFieldMapper.Parser<?>)null, Collections.emptyMap());
        }

        @Override
        public String typeName() {
            return GeoPointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query geoShapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            LatLonGeometry[] luceneGeometries = GeoShapeUtils.toLuceneGeometry(fieldName, context, shape, relation);
            if (luceneGeometries.length == 0) {
                return new MatchNoDocsQuery();
            }
            Query query = LatLonPoint.newGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (LatLonGeometry[])luceneGeometries);
            if (this.hasDocValues()) {
                Query dvQuery = LatLonDocValuesField.newSlowGeometryQuery((String)fieldName, (ShapeField.QueryRelation)relation.getLuceneRelation(), (LatLonGeometry[])luceneGeometries);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new AbstractLatLonPointIndexFieldData.Builder(this.name(), CoreValuesSourceType.GEOPOINT);
        }

        @Override
        public Query distanceFeatureQuery(Object origin, String pivot, SearchExecutionContext context) {
            GeoPoint originGeoPoint;
            if (origin instanceof GeoPoint) {
                originGeoPoint = (GeoPoint)origin;
            } else if (origin instanceof String) {
                originGeoPoint = GeoUtils.parseFromString((String)origin);
            } else {
                throw new IllegalArgumentException("Illegal type [" + origin.getClass() + "] for [origin]! Must be of type [geo_point] or [string] for geo_point fields!");
            }
            double pivotDouble = DistanceUnit.DEFAULT.parse(pivot, DistanceUnit.DEFAULT);
            return LatLonPoint.newDistanceFeatureQuery((String)this.name(), (float)1.0f, (double)originGeoPoint.lat(), (double)originGeoPoint.lon(), (double)pivotDouble);
        }
    }
}

