/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.elasticsearch.Version;
import org.elasticsearch.index.mapper.AllFieldMapper;
import org.elasticsearch.index.mapper.DynamicRuntimeFieldsBuilder;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.RuntimeFieldType;

public final class MapperRegistry {
    private final Map<String, Mapper.TypeParser> mapperParsers;
    private final Map<String, RuntimeFieldType.Parser> runtimeFieldTypeParsers;
    private final DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers6x;
    private final Function<String, Predicate<String>> fieldFilter;

    public MapperRegistry(Map<String, Mapper.TypeParser> mapperParsers, Map<String, RuntimeFieldType.Parser> runtimeFieldTypeParsers, DynamicRuntimeFieldsBuilder dynamicRuntimeFieldsBuilder, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, Function<String, Predicate<String>> fieldFilter) {
        this.mapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, Mapper.TypeParser>(mapperParsers));
        this.runtimeFieldTypeParsers = runtimeFieldTypeParsers;
        this.dynamicRuntimeFieldsBuilder = dynamicRuntimeFieldsBuilder;
        this.metadataMapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(metadataMapperParsers));
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadata6x = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>();
        metadata6x.put("_all", AllFieldMapper.PARSER);
        metadata6x.putAll(metadataMapperParsers);
        this.metadataMapperParsers6x = Collections.unmodifiableMap(metadata6x);
        this.fieldFilter = fieldFilter;
    }

    public Map<String, Mapper.TypeParser> getMapperParsers() {
        return this.mapperParsers;
    }

    public Map<String, RuntimeFieldType.Parser> getRuntimeFieldTypeParsers() {
        return this.runtimeFieldTypeParsers;
    }

    public DynamicRuntimeFieldsBuilder getDynamicRuntimeFieldsBuilder() {
        return this.dynamicRuntimeFieldsBuilder;
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMapperParsers(Version indexCreatedVersion) {
        return indexCreatedVersion.onOrAfter(Version.V_7_0_0) ? this.metadataMapperParsers : this.metadataMapperParsers6x;
    }

    public Function<String, Predicate<String>> getFieldFilter() {
        return this.fieldFilter;
    }
}

