/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.admin.cluster.state.ClusterStateAction;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.DispatchingRestToXContentListener;
import org.elasticsearch.rest.action.RestCancellableNodeClient;
import org.elasticsearch.threadpool.ThreadPool;

public class RestClusterStateAction
extends BaseRestHandler {
    private final SettingsFilter settingsFilter;
    private final ThreadPool threadPool;
    private static final Set<String> RESPONSE_PARAMS;

    public RestClusterStateAction(SettingsFilter settingsFilter, ThreadPool threadPool) {
        this.settingsFilter = settingsFilter;
        this.threadPool = threadPool;
    }

    @Override
    public String getName() {
        return "cluster_state_action";
    }

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/_cluster/state"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/state/{metric}"), new RestHandler.Route(RestRequest.Method.GET, "/_cluster/state/{metric}/{indices}")));
    }

    @Override
    public boolean allowSystemIndexAccessByDefault() {
        return true;
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        boolean isAllIndicesOnly;
        ClusterStateRequest clusterStateRequest = Requests.clusterStateRequest();
        clusterStateRequest.indicesOptions(IndicesOptions.fromRequest(request, clusterStateRequest.indicesOptions()));
        clusterStateRequest.local(request.paramAsBoolean("local", clusterStateRequest.local()));
        clusterStateRequest.masterNodeTimeout(request.paramAsTime("master_timeout", clusterStateRequest.masterNodeTimeout()));
        if (request.hasParam("wait_for_metadata_version")) {
            clusterStateRequest.waitForMetadataVersion(request.paramAsLong("wait_for_metadata_version", 0L));
        }
        clusterStateRequest.waitForTimeout(request.paramAsTime("wait_for_timeout", ClusterStateRequest.DEFAULT_WAIT_FOR_NODE_TIMEOUT));
        String[] indices = Strings.splitStringByCommaToArray(request.param("indices", "_all"));
        boolean bl = isAllIndicesOnly = indices.length == 1 && "_all".equals(indices[0]);
        if (!isAllIndicesOnly) {
            clusterStateRequest.indices(indices);
        }
        if (request.hasParam("metric")) {
            EnumSet<ClusterState.Metric> metrics = ClusterState.Metric.parseString(request.param("metric"), true);
            clusterStateRequest.nodes(metrics.contains((Object)ClusterState.Metric.NODES) || metrics.contains((Object)ClusterState.Metric.MASTER_NODE));
            clusterStateRequest.routingTable(metrics.contains((Object)ClusterState.Metric.ROUTING_TABLE) || metrics.contains((Object)ClusterState.Metric.ROUTING_NODES));
            clusterStateRequest.metadata(metrics.contains((Object)ClusterState.Metric.METADATA));
            clusterStateRequest.blocks(metrics.contains((Object)ClusterState.Metric.BLOCKS));
            clusterStateRequest.customs(metrics.contains((Object)ClusterState.Metric.CUSTOMS));
        }
        this.settingsFilter.addFilterSettingParams(request);
        return channel -> new RestCancellableNodeClient(client, request.getHttpChannel()).execute(ClusterStateAction.INSTANCE, clusterStateRequest, new DispatchingRestToXContentListener<RestClusterStateResponse>(this.threadPool.executor("management"), channel, request){

            @Override
            protected ToXContent.Params getParams() {
                return new ToXContent.DelegatingMapParams(Collections.singletonMap("context_mode", Metadata.CONTEXT_MODE_API), (ToXContent.Params)request);
            }
        }.map(response -> new RestClusterStateResponse(clusterStateRequest, (ClusterStateResponse)response, this.threadPool::relativeTimeInMillis)));
    }

    @Override
    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }

    static {
        HashSet<String> responseParams = new HashSet<String>();
        responseParams.add("metric");
        responseParams.addAll(Settings.FORMAT_PARAMS);
        RESPONSE_PARAMS = Collections.unmodifiableSet(responseParams);
    }

    private static class RestClusterStateResponse
    implements ToXContentObject {
        private final ClusterStateRequest request;
        private final ClusterStateResponse response;
        private final LongSupplier currentTimeMillisSupplier;
        private final long startTimeMillis;

        RestClusterStateResponse(ClusterStateRequest request, ClusterStateResponse response, LongSupplier currentTimeMillisSupplier) {
            this.request = request;
            this.response = response;
            this.currentTimeMillisSupplier = currentTimeMillisSupplier;
            this.startTimeMillis = currentTimeMillisSupplier.getAsLong();
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (!this.request.local() && this.currentTimeMillisSupplier.getAsLong() - this.startTimeMillis > this.request.masterNodeTimeout().millis()) {
                throw new ElasticsearchTimeoutException("Timed out getting cluster state", new Object[0]);
            }
            builder.startObject();
            if (this.request.waitForMetadataVersion() != null) {
                builder.field("wait_for_timed_out", this.response.isWaitForTimedOut());
            }
            builder.field("cluster_name", this.response.getClusterName().value());
            ClusterState responseState = this.response.getState();
            if (responseState != null) {
                responseState.toXContent(builder, params);
            }
            builder.endObject();
            return builder;
        }
    }

    static final class Fields {
        static final String WAIT_FOR_TIMED_OUT = "wait_for_timed_out";
        static final String CLUSTER_NAME = "cluster_name";

        Fields() {
        }
    }
}

