/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.connector.kafka.serialization;

import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.serialization.Deserializer;
import org.dbsyncer.common.util.JsonUtil;

public class JsonToMapDeserializer
implements Deserializer<Map> {
    private String encoding = "UTF8";

    public void configure(Map<String, ?> configs, boolean isKey) {
        String propertyName = isKey ? "key.deserializer.encoding" : "value.deserializer.encoding";
        Object encodingValue = configs.get(propertyName);
        if (encodingValue == null) {
            encodingValue = configs.get("deserializer.encoding");
        }
        if (encodingValue != null && encodingValue instanceof String) {
            this.encoding = (String)encodingValue;
        }
    }

    public Map deserialize(String topic, byte[] data) {
        try {
            if (data == null) {
                return null;
            }
            return (Map)JsonUtil.jsonToObj((String)new String(data, this.encoding), LinkedHashMap.class);
        }
        catch (UnsupportedEncodingException e) {
            throw new SerializationException("Error when deserializing byte[] to string due to unsupported encoding " + this.encoding);
        }
    }

    public void close() {
    }
}

