/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.ddl.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.connector.base.ConnectorFactory;
import org.dbsyncer.parser.ddl.AlterStrategy;
import org.dbsyncer.parser.ddl.DDLParser;
import org.dbsyncer.parser.ddl.alter.AddStrategy;
import org.dbsyncer.parser.ddl.alter.ChangeStrategy;
import org.dbsyncer.parser.ddl.alter.DropStrategy;
import org.dbsyncer.parser.ddl.alter.ModifyStrategy;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.sdk.config.DDLConfig;
import org.dbsyncer.sdk.connector.database.Database;
import org.dbsyncer.sdk.enums.DDLOperationEnum;
import org.dbsyncer.sdk.model.Field;
import org.dbsyncer.sdk.model.MetaInfo;
import org.dbsyncer.sdk.spi.ConnectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DDLParserImpl
implements DDLParser {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private ConnectorFactory connectorFactory;
    private final Map<AlterOperation, AlterStrategy> STRATEGIES = new ConcurrentHashMap<AlterOperation, AlterStrategy>();

    @PostConstruct
    private void init() {
        this.STRATEGIES.putIfAbsent(AlterOperation.MODIFY, new ModifyStrategy());
        this.STRATEGIES.putIfAbsent(AlterOperation.ADD, new AddStrategy());
        this.STRATEGIES.putIfAbsent(AlterOperation.CHANGE, new ChangeStrategy());
        this.STRATEGIES.putIfAbsent(AlterOperation.DROP, new DropStrategy());
    }

    @Override
    public DDLConfig parseDDlConfig(String sql, String targetConnectorType, String targetTableName, List<FieldMapping> originalFieldMappings) {
        ConnectorService connectorService = this.connectorFactory.getConnectorService(targetConnectorType);
        DDLConfig ddlConfig = new DDLConfig();
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            if (statement instanceof Alter) {
                Alter alter = (Alter)statement;
                Database database = (Database)connectorService;
                String quotation = database.buildSqlWithQuotation();
                alter.getTable().setName(quotation + targetTableName + quotation);
                ddlConfig.setSql(alter.toString());
                for (AlterExpression expression : alter.getAlterExpressions()) {
                    if (!this.STRATEGIES.containsKey(expression.getOperation())) continue;
                    this.STRATEGIES.get(expression.getOperation()).parse(expression, ddlConfig, originalFieldMappings);
                }
            }
        }
        catch (JSQLParserException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
        return ddlConfig;
    }

    @Override
    public List<FieldMapping> refreshFiledMappings(List<FieldMapping> originalFieldMappings, MetaInfo originMetaInfo, MetaInfo targetMetaInfo, DDLConfig targetDDLConfig) {
        LinkedList<FieldMapping> newTargetMappingList = new LinkedList<FieldMapping>();
        for (FieldMapping fieldMapping : originalFieldMappings) {
            String fieldSourceName = fieldMapping.getSource().getName();
            String filedTargetName = fieldMapping.getTarget().getName();
            if (fieldSourceName.equals(targetDDLConfig.getSourceColumnName())) {
                Field target;
                Field source;
                if (targetDDLConfig.getDdlOperationEnum() == DDLOperationEnum.ALTER_MODIFY) {
                    source = originMetaInfo.getColumn().stream().filter(x -> StringUtil.equals((CharSequence)x.getName(), (CharSequence)fieldSourceName)).findFirst().get();
                    target = targetMetaInfo.getColumn().stream().filter(x -> StringUtil.equals((CharSequence)x.getName(), (CharSequence)filedTargetName)).findFirst().get();
                    newTargetMappingList.add(new FieldMapping(source, target));
                    continue;
                }
                if (targetDDLConfig.getDdlOperationEnum() == DDLOperationEnum.ALTER_CHANGE) {
                    source = originMetaInfo.getColumn().stream().filter(x -> StringUtil.equals((CharSequence)x.getName(), (CharSequence)targetDDLConfig.getChangedColumnName())).findFirst().get();
                    target = targetMetaInfo.getColumn().stream().filter(x -> StringUtil.equals((CharSequence)x.getName(), (CharSequence)targetDDLConfig.getChangedColumnName())).findFirst().get();
                    newTargetMappingList.add(new FieldMapping(source, target));
                    continue;
                }
            }
            newTargetMappingList.add(fieldMapping);
        }
        if (DDLOperationEnum.ALTER_ADD == targetDDLConfig.getDdlOperationEnum()) {
            List addFields = targetDDLConfig.getAddFields();
            for (Field field : addFields) {
                Field source = originMetaInfo.getColumn().stream().filter(x -> StringUtil.equals((CharSequence)x.getName(), (CharSequence)field.getName())).findFirst().get();
                Field target = targetMetaInfo.getColumn().stream().filter(x -> StringUtil.equals((CharSequence)x.getName(), (CharSequence)field.getName())).findFirst().get();
                newTargetMappingList.add(new FieldMapping(source, target));
            }
        }
        if (DDLOperationEnum.ALTER_DROP == targetDDLConfig.getDdlOperationEnum()) {
            List removeFields = targetDDLConfig.getRemoveFields();
            for (Field field : removeFields) {
                newTargetMappingList.removeIf(x -> StringUtil.equals((CharSequence)x.getSource().getName(), (CharSequence)field.getName()));
            }
        }
        return newTargetMappingList;
    }
}

