/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.enums;

import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.ParserException;
import org.dbsyncer.parser.convert.Handler;
import org.dbsyncer.parser.convert.handler.AesDecryptHandler;
import org.dbsyncer.parser.convert.handler.AesEncryptHandler;
import org.dbsyncer.parser.convert.handler.AppendHandler;
import org.dbsyncer.parser.convert.handler.BytesToStringHandler;
import org.dbsyncer.parser.convert.handler.ClearHandler;
import org.dbsyncer.parser.convert.handler.DateHandler;
import org.dbsyncer.parser.convert.handler.DefaultHandler;
import org.dbsyncer.parser.convert.handler.LongToTimestampHandler;
import org.dbsyncer.parser.convert.handler.NumberToStringHandler;
import org.dbsyncer.parser.convert.handler.PrependHandler;
import org.dbsyncer.parser.convert.handler.RemStrFirstHandler;
import org.dbsyncer.parser.convert.handler.RemStrLastHandler;
import org.dbsyncer.parser.convert.handler.ReplaceHandler;
import org.dbsyncer.parser.convert.handler.Sha1Handler;
import org.dbsyncer.parser.convert.handler.StringToTimestampHandler;
import org.dbsyncer.parser.convert.handler.SubStrFirstHandler;
import org.dbsyncer.parser.convert.handler.SubStrLastHandler;
import org.dbsyncer.parser.convert.handler.TimestampHandler;
import org.dbsyncer.parser.convert.handler.TimestampToChineseStandardTimeHandler;
import org.dbsyncer.parser.convert.handler.TimestampToDateHandler;
import org.dbsyncer.parser.convert.handler.TimestampToLongHandler;
import org.dbsyncer.parser.convert.handler.UUIDHandler;

public enum ConvertEnum {
    DEFAULT("DEFAULT", "\u9ed8\u8ba4\u503c", 1, new DefaultHandler()),
    SYSTEM_TIMESTAMP("SYSTEM_TIMESTAMP", "\u7cfb\u7edf\u65f6\u95f4\u6233", 0, new TimestampHandler()),
    SYSTEM_DATE("SYSTEM_DATE", "\u7cfb\u7edf\u65e5\u671f", 0, new DateHandler()),
    TIMESTAMP_TO_DATE("TIMESTAMP_TO_DATE", "Timestamp\u8f6cDate", 0, new TimestampToDateHandler()),
    TIMESTAMP_TO_CHINESE_STANDARD_TIME("TIMESTAMP_TO_CHINESE_STANDARD_TIME", "Timestamp\u8f6cyyyy-MM-dd HH:mm:ss", 0, new TimestampToChineseStandardTimeHandler()),
    TIMESTAMP_TO_LONG("TIMESTAMP_TO_LONG", "Timestamp\u8f6cLong", 0, new TimestampToLongHandler()),
    LONG_TO_TIMESTAMP("LONG_TO_TIMESTAMP", "Long\u8f6cTimestamp", 0, new LongToTimestampHandler()),
    STRING_TO_TIMESTAMP("STRING_TO_TIMESTAMP", "String\u8f6cTimestamp", 0, new StringToTimestampHandler()),
    NUMBER_TO_STRING("NUMBER_TO_STRING", "Number\u8f6cString", 0, new NumberToStringHandler()),
    BYTES_TO_STRING("BYTES_TO_STRING", "Byte[]\u8f6cString", 0, new BytesToStringHandler()),
    REPLACE("REPLACE", "\u66ff\u6362", 2, new ReplaceHandler()),
    PREPEND("PREPEND", "\u524d\u9762\u8ffd\u52a0", 1, new PrependHandler()),
    APPEND("APPEND", "\u540e\u9762\u8ffd\u52a0", 1, new AppendHandler()),
    AES_ENCRYPT("AES_ENCRYPT", "AES\u52a0\u5bc6", 1, new AesEncryptHandler()),
    AES_DECRYPT("AES_DECRYPT", "AES\u89e3\u5bc6", 1, new AesDecryptHandler()),
    SHA1("SHA1", "SHA1\u52a0\u5bc6", 0, new Sha1Handler()),
    UUID("UUID", "UUID", 0, new UUIDHandler()),
    REM_STR_FIRST("REM_STR_FIRST", "\u53bb\u6389\u9996\u5b57\u7b26", 0, new RemStrFirstHandler()),
    REM_STR_LAST("REM_STR_LAST", "\u53bb\u6389\u5c3e\u5b57\u7b26", 0, new RemStrLastHandler()),
    SUB_STR_FIRST("SUB_STR_FIRST", "\u4ece\u524d\u9762\u622a\u53d6N\u4e2a\u5b57\u7b26", 1, new SubStrFirstHandler()),
    SUB_STR_LAST("SUB_STR_LAST", "\u4ece\u540e\u9762\u622a\u53d6N\u4e2a\u5b57\u7b26", 1, new SubStrLastHandler()),
    CLEAR("CLEAR", "\u6e05\u7a7a", 0, new ClearHandler());

    private String code;
    private String name;
    private int argNum;
    private Handler handler;

    private ConvertEnum(String code, String name, int argNum, Handler handler) {
        this.code = code;
        this.name = name;
        this.argNum = argNum;
        this.handler = handler;
    }

    public static Handler getHandler(String code) throws ParserException {
        for (ConvertEnum e : ConvertEnum.values()) {
            if (!StringUtil.equals((CharSequence)code, (CharSequence)e.getCode())) continue;
            return e.getHandler();
        }
        throw new ParserException(String.format("Handler code \"%s\" does not exist.", code));
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public int getArgNum() {
        return this.argNum;
    }

    public Handler getHandler() {
        return this.handler;
    }
}

