/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.flush.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Resource;
import org.dbsyncer.common.config.TableGroupBufferConfig;
import org.dbsyncer.parser.flush.BufferActuator;
import org.dbsyncer.parser.flush.impl.TableGroupBufferActuator;
import org.dbsyncer.parser.model.WriterRequest;
import org.dbsyncer.sdk.listener.ChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.stereotype.Component;

@Component
public final class BufferActuatorRouter
implements DisposableBean {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private TableGroupBufferConfig tableGroupBufferConfig;
    @Resource
    private TableGroupBufferActuator tableGroupBufferActuator;
    @Resource
    private BufferActuator generalBufferActuator;
    private Map<String, Map<String, TableGroupBufferActuator>> router = new ConcurrentHashMap<String, Map<String, TableGroupBufferActuator>>();

    public void execute(String metaId, String tableGroupId, ChangedEvent event) {
        if (this.router.containsKey(metaId) && this.router.get(metaId).containsKey(tableGroupId)) {
            this.router.get(metaId).get(tableGroupId).offer(new WriterRequest(tableGroupId, event));
            return;
        }
        this.generalBufferActuator.offer(new WriterRequest(tableGroupId, event));
    }

    public void bind(String metaId, String tableGroupId) {
        this.router.computeIfAbsent(metaId, k -> new ConcurrentHashMap());
        if (this.router.get(metaId).size() >= this.tableGroupBufferConfig.getMaxBufferActuatorSize()) {
            return;
        }
        this.router.get(metaId).computeIfAbsent(tableGroupId, k -> {
            TableGroupBufferActuator newBufferActuator = null;
            try {
                newBufferActuator = (TableGroupBufferActuator)this.tableGroupBufferActuator.clone();
                newBufferActuator.setTableGroupId(tableGroupId);
                newBufferActuator.buildConfig();
            }
            catch (CloneNotSupportedException ex) {
                this.logger.error(ex.getMessage(), (Throwable)ex);
            }
            return newBufferActuator;
        });
    }

    public void unbind(String metaId) {
        if (this.router.containsKey(metaId)) {
            this.router.get(metaId).values().forEach(TableGroupBufferActuator::stop);
            this.router.remove(metaId);
        }
    }

    public void destroy() {
        this.router.values().forEach(map -> map.values().forEach(TableGroupBufferActuator::stop));
        this.router.clear();
    }

    public AtomicLong getQueueSize() {
        AtomicLong total = new AtomicLong();
        this.router.values().forEach(map -> map.values().forEach(actuator -> total.addAndGet(actuator.getQueue().size())));
        return total;
    }

    public AtomicLong getQueueCapacity() {
        AtomicLong total = new AtomicLong();
        this.router.values().forEach(map -> map.values().forEach(actuator -> total.addAndGet(actuator.getQueueCapacity())));
        return total;
    }

    public Map<String, Map<String, TableGroupBufferActuator>> getRouter() {
        return Collections.unmodifiableMap(this.router);
    }
}

