/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.flush.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.dbsyncer.common.config.BufferActuatorConfig;
import org.dbsyncer.common.config.StorageConfig;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.flush.AbstractBufferActuator;
import org.dbsyncer.parser.model.Mapping;
import org.dbsyncer.parser.model.Meta;
import org.dbsyncer.parser.model.StorageRequest;
import org.dbsyncer.parser.model.StorageResponse;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.storage.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class StorageBufferActuator
extends AbstractBufferActuator<StorageRequest, StorageResponse> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private StorageConfig storageConfig;
    @Resource
    private StorageService storageService;
    @Resource
    private Executor storageExecutor;
    @Resource
    private ProfileComponent profileComponent;

    @PostConstruct
    private void init() {
        this.setConfig((BufferActuatorConfig)this.storageConfig);
        this.buildConfig();
    }

    @Override
    protected String getPartitionKey(StorageRequest request) {
        return request.getMetaId();
    }

    @Override
    protected void partition(StorageRequest request, StorageResponse response) {
        response.setMetaId(request.getMetaId());
        response.getDataList().add(request.getRow());
    }

    @Override
    protected void pull(StorageResponse response) {
        this.storageExecutor.execute(() -> this.storageService.addBatch(StorageEnum.DATA, response.getMetaId(), response.getDataList()));
    }

    @Override
    protected void offerFailed(BlockingQueue<StorageRequest> queue, StorageRequest request) {
        Mapping mapping;
        Meta meta = this.profileComponent.getMeta(request.getMetaId());
        if (meta != null && (mapping = this.profileComponent.getMapping(meta.getMappingId())) != null) {
            this.logger.info("{}, data={}", (Object)mapping.getName(), (Object)request.getRow());
        }
    }

    @Override
    public Executor getExecutor() {
        return this.storageExecutor;
    }
}

