/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.flush.impl;

import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.dbsyncer.common.config.BufferActuatorConfig;
import org.dbsyncer.common.config.TableGroupBufferConfig;
import org.dbsyncer.common.scheduled.ScheduledTaskJob;
import org.dbsyncer.common.scheduled.ScheduledTaskService;
import org.dbsyncer.common.util.ThreadPoolUtil;
import org.dbsyncer.common.util.UUIDUtil;
import org.dbsyncer.parser.flush.BufferRequest;
import org.dbsyncer.parser.flush.impl.GeneralBufferActuator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public final class TableGroupBufferActuator
extends GeneralBufferActuator
implements Cloneable {
    @Resource
    private TableGroupBufferConfig tableGroupBufferConfig;
    @Resource
    private ScheduledTaskService scheduledTaskService;
    private ThreadPoolTaskExecutor threadPoolTaskExecutor;
    private String taskKey;
    private String tableGroupId;
    private volatile boolean running;

    @Override
    public void init() {
    }

    @Override
    protected boolean isRunning(BufferRequest request) {
        return this.running;
    }

    @Override
    public Executor getExecutor() {
        return this.threadPoolTaskExecutor;
    }

    @Override
    public void buildConfig() {
        super.setConfig((BufferActuatorConfig)this.tableGroupBufferConfig);
        super.buildQueueConfig();
        this.taskKey = UUIDUtil.getUUID();
        int coreSize = this.tableGroupBufferConfig.getThreadCoreSize();
        int maxSize = this.tableGroupBufferConfig.getMaxThreadSize();
        int queueCapacity = this.tableGroupBufferConfig.getThreadQueueCapacity();
        String threadNamePrefix = "TableGroupExecutor-" + this.tableGroupId + "-";
        this.threadPoolTaskExecutor = ThreadPoolUtil.newThreadPoolTaskExecutor((int)coreSize, (int)maxSize, (int)queueCapacity, (int)30, (String)threadNamePrefix);
        this.running = true;
        this.scheduledTaskService.start(this.taskKey, (long)this.tableGroupBufferConfig.getBufferPeriodMillisecond(), (ScheduledTaskJob)this);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void stop() {
        this.running = false;
        if (this.threadPoolTaskExecutor != null) {
            this.threadPoolTaskExecutor.shutdown();
        }
        this.scheduledTaskService.stop(this.taskKey);
    }

    public String getTableGroupId() {
        return this.tableGroupId;
    }

    public void setTableGroupId(String tableGroupId) {
        this.tableGroupId = tableGroupId;
    }
}

