/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.impl;

import java.time.Instant;
import java.util.HashMap;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.dbsyncer.common.util.StringUtil;
import org.dbsyncer.parser.LogService;
import org.dbsyncer.parser.LogType;
import org.dbsyncer.parser.ProfileComponent;
import org.dbsyncer.parser.model.SystemConfig;
import org.dbsyncer.sdk.enums.StorageEnum;
import org.dbsyncer.sdk.storage.StorageService;
import org.dbsyncer.storage.impl.SnowflakeIdWorker;
import org.springframework.stereotype.Component;

@Component
public class LogServiceImpl
implements LogService {
    @Resource
    private StorageService storageService;
    @Resource
    private SnowflakeIdWorker snowflakeIdWorker;
    @Resource
    private Executor storageExecutor;
    @Resource
    private ProfileComponent profileComponent;

    @Override
    public void log(LogType logType) {
        this.asyncWrite(logType.getType(), String.format("%s%s", logType.getName(), logType.getMessage()));
    }

    @Override
    public void log(LogType logType, String msg) {
        this.asyncWrite(logType.getType(), null == msg ? logType.getMessage() : msg);
    }

    @Override
    public void log(LogType logType, String format, Object ... args) {
        this.asyncWrite(logType.getType(), String.format(format, args));
    }

    private void asyncWrite(String type, String error) {
        this.storageExecutor.execute(() -> {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("id", String.valueOf(this.snowflakeIdWorker.nextId()));
            params.put("type", type);
            params.put("json", StringUtil.substring((String)error, (int)0, (int)this.getSystemConfig().getMaxStorageErrorLength()));
            params.put("createTime", Instant.now().toEpochMilli());
            this.storageService.add(StorageEnum.LOG, params);
        });
    }

    private SystemConfig getSystemConfig() {
        return this.profileComponent.getSystemConfig();
    }
}

