/*
 * Decompiled with CFR 0.152.
 */
package org.dbsyncer.parser.sql.impl;

import java.util.List;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.insert.Insert;
import org.dbsyncer.parser.model.FieldMapping;
import org.dbsyncer.parser.sql.SqlParser;

public final class InsertSql
implements SqlParser {
    private String sql;
    private String sourceTableName;
    private String targetTableName;
    private List<FieldMapping> fieldMappingList;

    public InsertSql(String sql, String sourceTableName, String targetTableName, List<FieldMapping> fieldMappingList) {
        this.sql = sql;
        this.sourceTableName = sourceTableName;
        this.targetTableName = targetTableName;
        this.fieldMappingList = fieldMappingList;
    }

    @Override
    public String parse() {
        try {
            Insert insert = (Insert)CCJSqlParserUtil.parse((String)this.sql);
            Table table = new Table();
            table.setName(this.targetTableName);
            insert.setTable(table);
            ExpressionList columns = insert.getColumns();
            for (Column column : columns) {
                this.fieldMappingList.stream().filter(x -> x.getSource().getName().equals(column.getColumnName().replaceAll("\"", ""))).findFirst().ifPresent(fieldMapping -> column.setColumnName(fieldMapping.getTarget().getName()));
            }
            return insert.toString();
        }
        catch (JSQLParserException e) {
            throw new RuntimeException(e);
        }
    }
}

